#include "xev.h"
#include "enemy.h"
#include "enemy_func.h"

PRIVATE char *fn[] = {
      "barra.img",
      "zorbak.img",
      "ato.img"
};

PRIVATE struct {
      int x;
      int char_no;
} map_chijou_enemy[YMAP][6] , enemy_map[YMAP][3];

PRIVATE Pixmap pixmap[3],pixmap_mask[3];
PRIVATE GC gc[3];
PRIVATE int (*func[19])();
PRIVATE void (*init_func[19])();
PRIVATE int (*Cfunc[18])();
PRIVATE void (*Cinit_func[18])();
PRIVATE int ene_num[5] = {
      40,30,15,20,15};

void SetChiChar()
{
      int c_no;
      char img[CSIZE*CSIZE] , mask[128];
      XGCValues gcv;

      gcv.graphics_exposures = False;
      for(c_no = 0 ; c_no < 3 ; c_no++) {
            int x,y;
            
            sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
            LoadChar(tpath,img , sizeof(img));
	    
            pixmap[c_no] = XCreatePixmap(d,w,CSIZE,CSIZE,depth);
            bzero(mask , sizeof(mask));
            gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);

	    DrawChar32(img , mask , gc[c_no],pixmap[c_no]);
            pixmap_mask[c_no] 
              = XCreateBitmapFromData(d,w,mask,CSIZE,CSIZE);
            XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
}

void EnemyFree()
{
      int i;

      for(i = 0 ; i > 3 ; i++) {
	    XFreePixmap(d,pixmap[i]);
	    XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }
}

void InitChijouEnemy(stage)
     int stage;
{
      int i;
      FILE *fp;
      char fn[256];
      int y;

      sprintf(fn,"%s/chijou_map%d.dat",MAP_DIR,stage);

      if( (fp = fopen(fn,"r")) == NULL) {
            perror("In InitChijouEnemy ");
            exit(errno);
      }
      
      for(y = 0 ; y < YMAP ; y++) {
            fscanf(fp,"%d %d %d %d %d %d %d %d %d %d %d %d",
		   &map_chijou_enemy[y][0].char_no,
		   &map_chijou_enemy[y][0].x,
		   &map_chijou_enemy[y][1].char_no,
		   &map_chijou_enemy[y][1].x,
		   &map_chijou_enemy[y][2].char_no,
		   &map_chijou_enemy[y][2].x,
		   &map_chijou_enemy[y][3].char_no,
		   &map_chijou_enemy[y][3].x,
		   &map_chijou_enemy[y][4].char_no,
		   &map_chijou_enemy[y][4].x,
		   &map_chijou_enemy[y][5].char_no,
		   &map_chijou_enemy[y][5].x
		   );
      }

      
      fclose(fp);

      for(i = 0 ; i < ENEMY_MAX ; i++)
        {
              enemy_chijou[i].enemy_no = 0;
        }
      
}

void InitKuuchuuEnemy(stage)
     int stage;
{
      int i;
      FILE *fp;
      char fn[256];
      int y;
      
      sprintf(fn,"%s/kuuchuu_map%d.dat",MAP_DIR,stage);
      if( (fp = fopen(fn,"r")) == NULL) {
            perror("In InitKuuchuuEnemy ");
            exit(errno);
      }

      for(y = 0 ; y < YMAP ; y++) {
            fscanf(fp,"%d %d %d %d %d %d",
                   &enemy_map[y][0].char_no,
                   &enemy_map[y][0].x,
                   &enemy_map[y][1].char_no,
                   &enemy_map[y][1].x,
                   &enemy_map[y][2].char_no,
                   &enemy_map[y][2].x
		   );
	    if(enemy_map[y][0].char_no != BACURA && 
	       enemy_map[y][0].char_no != ANDOA &&
	       enemy_map[y][0].char_no != SIO &&
	       enemy_map[y][0].char_no != GBZAKART) 
	      enemy_map[y][0].x = enemy_map[y][0].x*20/ene_num[game_level];
	
	    if(enemy_map[y][1].char_no != BACURA && 
	       enemy_map[y][1].char_no != ANDOA && 
	       enemy_map[y][1].char_no != SIO &&
	       enemy_map[y][1].char_no != GBZAKART)
	      enemy_map[y][1].x = enemy_map[y][1].x*20/ene_num[game_level];
	    
	    if(enemy_map[y][2].char_no != BACURA && 
	       enemy_map[y][2].char_no != ANDOA &&
	       enemy_map[y][2].char_no != SIO &&
               enemy_map[y][2].char_no != GBZAKART)
	      enemy_map[y][2].x = enemy_map[y][2].x*20/ene_num[game_level];
	    
      }
      
      fclose(fp);
      DomoStageInit(stage);
}

void FuncInit()
{
      func[BOMB] = Bomb;
      func[TOLOIDO] = Toloido;
      func[ZOSY] = Zosy;
      func[BACURA] = Bacura;
      func[ZAKART] = Zakart;
      func[TALKEN] = Talken;
      func[KAPI] = Kapi;
      func[TERAJI] = Teraji;
      func[ANDOA] = Ando;
      func[CORE] = Core;
      func[GIDO] = Gido;
      func[GZAKART] = GZakart;
      func[GBZAKART] = GBZakart;
      func[GEMINI] = Gemini;
      Cfunc[MIM] = Mim;
      func[JARA] = Jara;
      func[SIO] = Sio;
      func[BRAG] = Brag;
      func[ZOSYB] = Zosy;

      init_func[BOMB] = BombInit;
      init_func[TOLOIDO] = ToloidoInit;
      init_func[ZOSY] = ZosyInit;
      init_func[BACURA] = BacuInit;
      init_func[ZAKART] = ZakartInit;
      init_func[TALKEN] = TalkenInit;
      init_func[KAPI] = KapiInit;
      init_func[TERAJI] = TerajiInit;
      init_func[ANDOA] = AndoInit;
      init_func[GIDO] = GidoInit;
      init_func[GZAKART] = GZakartInit;
      Cinit_func[MIM] = MimInit;
      init_func[GBZAKART] = GBZakartInit;
      init_func[GEMINI] = BombInit;
      init_func[JARA] = JaraInit;
      init_func[SIO] = SioInit;
      init_func[ZOSYB] = ZosyInitB;
      /*init_func[BRAG] = BragInit;*/
      
      Cfunc[BOMB] = CBomb;
      Cfunc[ATO] = Ato;
      Cfunc[SOL] = Sol;
      Cfunc[ROGRAM] = Rogram;
      Cfunc[GROBDD] = Grobd;
      Cfunc[GROBDS] = Grobd;
      Cfunc[GROBDU] = Grobd;
      Cfunc[GROBDDS] = Grobd;
      Cfunc[BARRA] = ChijouD;
      Cfunc[ZORBAK] = ChijouD;
      Cfunc[SPFLAG] = SPFlag;
      Cfunc[DELOTA] = Delota;
      Cfunc[GDELOTA] = GDelota;
      Cfunc[BOZAROG] = BozaRogram;
      Cfunc[BONODORI] = Bonodo;
      Cfunc[MSG] = Msg;
      Cfunc[DOMOGRAM] = Domogram;

      Cinit_func[BOMB] = ChijouInit2;
      Cinit_func[ATO] = ChijouInit2;
      Cinit_func[SOL] = ChijouInit2;
      Cinit_func[ROGRAM] = ChijouInit2;
      Cinit_func[GROBDD] = ChijouInit2;
      Cinit_func[GROBDS] = ChijouInit2;
      Cinit_func[GROBDU] = ChijouInit2;
      Cinit_func[GROBDDS] = ChijouInit2;
      Cinit_func[BARRA] = ChijouInit2;
      Cinit_func[ZORBAK] = ChijouInit2;
      Cinit_func[SPFLAG] = SPFlagInit;
      Cinit_func[DELOTA] = ChijouInit2;
      Cinit_func[GDELOTA] = ChijouInit2;
      Cinit_func[BOZAROG] = BozaRogInit;
      Cinit_func[BONODORI] = BonodoInit;
      Cinit_func[MSG] = ChijouInit2;
      Cinit_func[DOMOGRAM] = DomoInit;
}

void ChijouInit2(enemy_no,x,char_no)
     int enemy_no,x,char_no;
{
      enemy_chijou[enemy_no].tmp1 = 0;
      enemy_chijou[enemy_no].tmp2 = 0;
      enemy_chijou[enemy_no].enemy_no  = char_no;
      enemy_chijou[enemy_no].x.dummy = x*CSIZE*32768;
      enemy_chijou[enemy_no].y.dummy = -32*65536;
      enemy_chijou[enemy_no].vx = 0;
			enemy_chijou[enemy_no].vy = STPF*65536;
      
      if(map[scrl_ptr][x/2] == UMINO || map[scrl_ptr][x/2] == BARA)
	enemy_chijou[enemy_no].tmp3 = 0;
      else
	enemy_chijou[enemy_no].tmp3 = 1;
}

void ChijouInit(scrl_ptr)
     int scrl_ptr;
{
      int i,enemy_no = 0;
      
      if(map_chijou_enemy[scrl_ptr][0].char_no != 0) {
	    int i;
	    
	    for(i = 0 ; i < 6 ; i++) {
		  if(map_chijou_enemy[scrl_ptr][i].char_no == 0)
		    break;
		  
		  for(enemy_no = 8 ; enemy_no < ENEMY_MAX ; enemy_no++){
			if(enemy_chijou[enemy_no].enemy_no != 0)
			  continue;
			
			Cinit_func[map_chijou_enemy[scrl_ptr][i].char_no]
			  (enemy_no,map_chijou_enemy[scrl_ptr][i].x,
			   map_chijou_enemy[scrl_ptr][i].char_no);
			break;
		  }
	    }
      }
}

int Ato(enemy_no)
     int enemy_no;
{
      int sx,sy;
      
      enemy_chijou[enemy_no].y.dummy += enemy_chijou[enemy_no].vy;
      sx = enemy_chijou[enemy_no].x.sht[UNION];
      sy = enemy_chijou[enemy_no].y.sht[UNION];
      SetSprite(sx,sy,pixmap[2],gc[2],CSIZE,CSIZE);

      if(sy > YSIZE) {
            enemy_chijou[enemy_no].enemy_no = 0;
      }
      return 0;
}

int ChijouD(enemy_no)
     int enemy_no;
{
      int sx,sy;

      enemy_chijou[enemy_no].y.dummy += enemy_chijou[enemy_no].vy;
      sx = enemy_chijou[enemy_no].x.sht[UNION];
      sy = enemy_chijou[enemy_no].y.sht[UNION];
      SetSprite(sx,sy,pixmap[enemy_chijou[enemy_no].enemy_no-3],
		gc[enemy_chijou[enemy_no].enemy_no-3],
		CSIZE,CSIZE);

      if(sy > YSIZE) {
	    enemy_chijou[enemy_no].enemy_no = 0;
      }	
      
      if((jx.sht[UNION] - sx) > -20 &&
	 (jx.sht[UNION] - sx) < 20 &&
         (jy.sht[UNION] - sy) > 192 &&
	 (jy.sht[UNION] - sy) < 224)
	shojun_flag = 1;

      if(shot_chi.z  == 1){
	    if((shot_chi.x.sht[UNION] - sx) > -10 &&
	       (shot_chi.x.sht[UNION] - sx) < 32 && 
	       (shot_chi.y.sht[UNION] - sy) > -10 && 
	       (shot_chi.y.sht[UNION] - sy) < 42){
		  BombCInit(enemy_no);
		  score += 200;
		  return 1;
	    }
      }else 
	return 0;
}

void Chijou()
{
      int enemy_no;
      int flag = 0;
      
      for(enemy_no = 0 ; enemy_no < ENEMY_MAX ; enemy_no++) {
	    if(enemy_chijou[enemy_no].enemy_no != 0) {
		  flag = Cfunc[enemy_chijou[enemy_no].enemy_no](enemy_no);

	    }

      }
      if(flag){
	    shot_chi.flag = 0;
	    shot_chi.z = 0;
      }
}

void InitEnemy()
{
      int i;
      
      for(i = 0 ; i < ENEMY_MAX ; i++)
        {
              enemy[i].enemy_no = 0;
	      enemy_chijou[i].enemy_no = 0;
        }
}


void EnemyInit(scrl_ptr) /*и*/
     int scrl_ptr;
{
      int enemy_no;
      int i;

      if(enemy_map[scrl_ptr][level].char_no != 0) {
	    for(i = 0 ; i < enemy_map[scrl_ptr][level].x ; i++)
	      for(enemy_no = 0 ; enemy_no < ENEMY_MAX ; enemy_no++)
		{
		      if(!enemy[enemy_no].enemy_no){
			    init_func[enemy_map[scrl_ptr][level].char_no](enemy_no);
			    enemy[enemy_no].enemy_no = 
			      enemy_map[scrl_ptr][level].char_no;
			    break;
		      }
		}
      }
}

int Enemy()
{
      int yararetaEN = 0;
      int rn;
      int enemy_no;
      
      for(enemy_no = 0 ; enemy_no < ENEMY_MAX ; enemy_no++)
	{
	      if(enemy[enemy_no].enemy_no != 0)
		yararetaEN |= func[enemy[enemy_no].enemy_no](enemy_no);

	}
      
      return yararetaEN;
}


	    


