#include "xev.h"
#include "enemy.h"

PRIVATE char *fn[] = {
      "zosy1.img",
      "zosy2.img",
      "zosy3.img"
};
PRIVATE Pixmap pixmap[3];
PRIVATE Pixmap pixmap_mask[3];
PRIVATE GC gc[3];
PRIVATE int shot_p[5][3] = {
      {2,5,12},
      {10,15,20},
      {15,20,25},
      {25,30,35},
      {40,50,60}
};

void ZosySetChar()
{
      int c_no;
      char img[CSIZE*CSIZE] , mask[128];
      XGCValues gcv;

      gcv.graphics_exposures = False;
      for(c_no = 0 ; c_no < 3 ; c_no++) {
            int x,y;
            
            sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
            LoadChar(tpath,img , sizeof(img));

            pixmap[c_no] = XCreatePixmap(d,w,CSIZE,CSIZE,depth);
            bzero(mask , sizeof(mask));
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);

	    DrawChar32(img , mask , gc[c_no],pixmap[c_no]);

            pixmap_mask[c_no] 
              = XCreateBitmapFromData(d,w,mask,CSIZE,CSIZE);
            XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
}

void ZosyFree()
{
      int i;

      for(i = 0 ; i < 3 ; i++) {
	    XFreePixmap(d,pixmap[i]);
	    XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }
}

void ZosyInit(enemy_no)
     int enemy_no;
{
      enemy[enemy_no].enemy_no = ZOSY;
      enemy[enemy_no].tmp1 = 0;
      enemy[enemy_no].tmp2 = rand() % 2;
      
      if(jx.sht[UNION] < XSIZE/2) {
	    enemy[enemy_no].x.dummy = (XSIZE - rand() % (XSIZE/2))*65536;
	    enemy[enemy_no].y.dummy = -(rand() & 31+32)*65536;
	    enemy[enemy_no].vx = -22500*(rand() % 2 + 2)*STPF;
	    enemy[enemy_no].vy = (rand() % 3+4 )*22500*STPF;
      }
      else
        {
              enemy[enemy_no].vx = (rand() % 2+2)*22500*STPF;
              enemy[enemy_no].vy = (rand() % 3+4)*22500*STPF;
              enemy[enemy_no].x.dummy = 65536*(rand() % (XSIZE/2));
              enemy[enemy_no].y.dummy = -(rand() & 31+32)*65536;
        }
}

void ZosyInitB(enemy_no)
     int enemy_no;
{
      enemy[enemy_no].enemy_no = ZOSYB;
      enemy[enemy_no].tmp1 = 0;
      enemy[enemy_no].tmp2 = rand() % 2;

      if(jx.sht[UNION] < XSIZE/2) {
            enemy[enemy_no].x.dummy = (XSIZE - rand() % (XSIZE/2))*65536;
            enemy[enemy_no].y.dummy = (rand() & 31+544)*65536;
            enemy[enemy_no].vx = -22500*(rand() % 2 + 2)*STPF;
            enemy[enemy_no].vy = -(rand() % 3+4 )*22500*STPF;
      }
      else
        {
              enemy[enemy_no].vx = (rand() % 2+2)*22500*STPF;
              enemy[enemy_no].vy = -(rand() % 3+4)*22500*STPF;
              enemy[enemy_no].x.dummy = 65536*(rand() % (XSIZE/2));
              enemy[enemy_no].y.dummy = (rand() & 31+544)*65536;
        }
}


int Zosy(enemy_no)
     int enemy_no;
{
      int i;
      int yararetaTL = 0;
      register int dx,dy;
      int sx,sy;
      
      enemy[enemy_no].x.dummy += enemy[enemy_no].vx;
      enemy[enemy_no].y.dummy += enemy[enemy_no].vy;
      sx = enemy[enemy_no].x.sht[UNION];
      sy = enemy[enemy_no].y.sht[UNION];
      enemy[enemy_no].tmp1 ++;
      enemy[enemy_no].tmp1 %= 3;
      dx = jx.sht[UNION] - sx; dy = jy.sht[UNION] - sy;
      
      if(dx > -20 && dx < 20 && dy > -20 && dy < 20)
        yararetaTL = 1;
      
      for(i = 0 ; i < SHOT_NUM ; i++) {
	    if(!shot[i].flag)
	      continue;
	    
	    if((shot[i].x.sht[UNION] - sx) > -20 && 
	       (shot[i].x.sht[UNION] - sx) < 20
	       && (shot[i].y.sht[UNION] - sy) > -24 && 
	       (shot[i].y.sht[UNION] - sy) < 24) {
		  score += 70+10*(rand() &3);
		  shot[i].flag = 0;
		  BombInit(enemy_no);
		  return 0;
	    }
      }
      
      if(sx < 0 ||sx > XSIZE
         || sy > YSIZE)	{
	    enemy[enemy_no].enemy_no = 0;
      } else {
              if(ABS(dx) < 24 || sy < 32) {
		    enemy[enemy_no].vy = ABS(enemy[enemy_no].vy)*SGN(dy);
		    if(enemy[enemy_no].tmp2 > 0 &&
		       (rand() & 127) < shot_p[game_level][level]) {
			  EShut(enemy_no,enemy[enemy_no].x.dummy,
				enemy[enemy_no].y.dummy);
			  enemy[enemy_no].tmp2--;
		    }
		    enemy[enemy_no].tmp2 += (enemy[enemy_no].tmp2==0);
	      }
	      
	      if(ABS(dy) < 24 || sx < 32 || sx > (XSIZE-32)) {
		    enemy[enemy_no].vx = ABS(enemy[enemy_no].vx)*SGN(dx);
		    
		    if(enemy[enemy_no].tmp2 > 0 &&
		       (rand() & 31) == 1) {
			  EShut(enemy_no,enemy[enemy_no].x.dummy,
				enemy[enemy_no].y.dummy);
			  enemy[enemy_no].tmp2--;
		    }
		    enemy[enemy_no].tmp2 += (enemy[enemy_no].tmp2==0);
	      }
              
              SetSprite(enemy[enemy_no].x.sht[UNION],
			enemy[enemy_no].y.sht[UNION],
			pixmap[enemy[enemy_no].tmp1],
			gc[enemy[enemy_no].tmp1],
			CSIZE,CSIZE);
        }
      
      return yararetaTL;
}



