//
// $Id: book_shelf.pov,v 1.1 1999/03/27 07:29:53 xblast Exp $
// $Log: book_shelf.pov,v $
// Revision 1.1  1999/03/27 07:29:53  xblast
// Initial revision
//
//
#include "BLGeneric.inc"

#declare woodTex =
texture {
  pigment {
    gradient z
    color_map {
      [0.0 color rgb <0,1.00,0>]
      [1.0 color rgb <0,0.33,0>]
    }
    scale 0.15
    turbulence 0.5
  }
}

#declare shelfSide =
box {
  <-0.1, 0.000, -2.000>
  < 0.1, 2.667,  0.667>
  texture {woodTex}
}

#declare shelfBoard =
box {
  <-1.9, -0.1, -1.900>
  < 1.9,  0.1,  0.567>
  texture {woodTex}
}

object {shelfSide translate <-1.85,0,0> }
object {shelfSide translate < 1.85,0,0> }

object {shelfBoard translate <0,0.200,0>}
object {shelfBoard translate <0,1.333,0>}
object {shelfBoard translate <0,2.467,0>}


#declare Book = 
union {
  difference {
    merge {
      cylinder {
        <0.0, 0.0, 0.0>
        <0.0, 1.0, 0.0>
        0.25
        scale <0.5,1.0,0.25>
      }
      box {
        <-0.125, 0.0, 0.0>
        < 0.125, 1.0, 0.75>
      }
    }
    box {
      <-0.10,-0.1, 0.01>
      < 0.10, 1.1, 0.85>
    }
  }
  box {
    <-0.1125, 0.05, 0.005>
    < 0.1125, 0.95, 0.7>
    pigment {color rgb <1,1,1>}
  }
}

#declare lightBook =
object {
  Book
  pigment {
    gradient y
    color_map {
      [0.0 color rgb <1.00,0.33,0.33>]
      [0.5 color rgb <1.00,0.33,0.33>]
      [0.5 color rgb <1.00,1.00,1.00>]
      [0.6 color rgb <1.00,1.00,1.00>]
      [0.6 color rgb <1.00,0.33,0.33>]
      [0.8 color rgb <1.00,0.33,0.33>]
      [0.8 color rgb <1.00,1.00,1.00>]
      [0.9 color rgb <1.00,1.00,1.00>]
      [0.9 color rgb <1.00,0.33,0.33>]
      [1.0 color rgb <1.00,0.33,0.33>]
    }
  }
  finish {Dull} 
}

#declare darkBook =
object {
  Book
  pigment {
    gradient y
    color_map {
      [0.0 color rgb <0.67,0.00,0.00>]
      [0.5 color rgb <0.67,0.00,0.00>]
      [0.5 color rgb <1.00,1.00,1.00>]
      [0.6 color rgb <1.00,1.00,1.00>]
      [0.6 color rgb <0.67,0.00,0.00>]
      [0.8 color rgb <0.67,0.00,0.00>]
      [0.8 color rgb <1.00,1.00,1.00>]
      [0.9 color rgb <1.00,1.00,1.00>]
      [0.9 color rgb <0.67,0.00,0.00>]
      [1.0 color rgb <0.67,0.00,0.00>]
    }
  }
  finish {Dull} 
}

#declare XP=-1.625
#while (XP<=1.625)
  object {lightBook translate <XP,0.200,-1.9>}
  object {darkBook translate <XP,1.333,-1.9>}
  #declare XP=XP+0.5
#end

#declare XP=-1.375
#while (XP<=1.625)
  object {darkBook translate <XP,0.200,-1.9>}
  object {lightBook translate <XP,1.333,-1.9>}
  #declare XP=XP+0.5
#end

object {lightBook rotate z*90 rotate y*45 translate <0,2.667,-1.75> }


