//
// $Id: menu_right_down.pov,v 1.1 1999/06/13 09:27:18 xblast Exp $
// $Log: menu_right_down.pov,v $
// Revision 1.1  1999/06/13 09:27:18  xblast
// Initial revision
//
//
#include "BLGeneric.inc"

#declare R1=seed(12345)

#declare Ziegel = 
superellipsoid {
  <0.5,0.5>
  scale <0.9,0.655,0.5>
  scale 0.5
  translate <0.5,0.3775,0.25>
}

#declare halbZiegel = 
superellipsoid {
  <0.5,0.5>
  scale <0.4,0.655,0.5>
  scale 0.5
  translate <0.25,0.3775,0.25>
}

box {
  <-10, -1, -1.95>
  <-0.2,   5,  2>
  pigment { color rgb <0.85,0.85,0.85> }
  finish {Dull}
  normal {bumps 0.2}
}

#if (0)
box {
  <-4,4.53,-2>
  < 4,4.56,2>
}
#end

union {
#declare XP=-2.0
#while(XP<2.0)
  #declare YP=0.0
  #while(YP<=3.02)
    #declare ZP=-2.1+0.1*rand(R1)
    #if (XP < -0.5) 
      object { Ziegel translate <XP,YP,ZP> }
    #end
    #declare YP=YP+1.51
  #end
  #declare XP=XP+1.0
#end
#declare XP=-2.5
#while(XP<1.5)
  #declare YP=0.755
  #while(YP<5.285)
    #declare ZP=-2.1+0.1*rand(R1)
    #if (XP < -0.5) 
      object { Ziegel translate <XP,YP,ZP> }
    #end
    #if (XP = -0.5)
      object { halbZiegel translate <XP,YP,ZP> }
    #end
    #if (YP=3.775)
      #if (XP < -0.5) 
        object { Ziegel translate <XP,-0.755,ZP> }
      #end
      #if (XP = -0.5)
       object { halbZiegel translate <XP,-0.755,ZP> }
      #end
    #end
    #declare YP=YP+1.51
  #end
  #declare XP=XP+1.0
#end
  pigment { color rgb <1,0,0> }
  finish {myDull}
  normal {granite scale 0.2}
}


#declare nagel = 
sphere {
  <0,0,0>, 1
  scale <0.2,0.1,0.2>
  pigment {color rgb <0.0,0.5,0>}
  finish {Dull}
}

#declare hubbel = 
union {
  sphere {<0,0,0>, 1 scale <0.2,0.05,0.05> rotate y*45  }
  sphere {<0,0,0>, 1 scale <0.2,0.05,0.05> rotate y*-45 translate <0.5,0.0,0.0>}
  sphere {<0,0,0>, 1 scale <0.2,0.05,0.05> rotate y*-45 translate <0.0,0.0,0.5>}
  sphere {<0,0,0>, 1 scale <0.2,0.05,0.05> rotate y*45  translate <0.5,0.0,0.5>}
}

#declare hubbel = 
union {
  sphere {<0,0,0>, 1 scale <0.2,0.05,0.05> rotate y*45  }
  sphere {<0,0,0>, 1 scale <0.2,0.05,0.05> rotate y*-45 translate <0.5,0.0,0.0>}
  sphere {<0,0,0>, 1 scale <0.2,0.05,0.05> rotate y*-45 translate <0.0,0.0,0.5>}
  sphere {<0,0,0>, 1 scale <0.2,0.05,0.05> rotate y*45  translate <0.5,0.0,0.5>}
}

#declare tile =
union {
  box {
    < 0.0,0.0,-2>
    < 2.1,0.3, 2>
  }
  #declare SP=0
  #while (SP<4)
    object {nagel translate < 1.75 - SP*0.5, 0.3,-1.75> }
    object {nagel translate < 1.75 - SP*0.5, 0.3, 1.50> }
    #declare SP=SP+1
  #end
  #declare SP=1
  #while (SP<6)
    object {nagel translate < 0.25, 0.3, - 1.75 + SP*3.25/6> }
    #declare SP=SP+1
  #end
  #declare XP=0.25
  #while (XP<1.70)
    #declare ZP=-1.25
    #while (ZP<1.25)
      object {hubbel scale <1,1,2.25/2.50> translate <XP,0.3,ZP> }
      #declare ZP=ZP+(2.25/2.50)
    #end
    #declare XP=XP+1.0
  #end
  pigment {color rgb <0,1,0>}
  finish {Dull metallic}
}

object {tile}

