//
// $Id: mr_beam_bear_O.pov,v 1.1 1999/04/04 11:56:46 xblast Exp $
// $Log: mr_beam_bear_O.pov,v $
// Revision 1.1  1999/04/04 11:56:46  xblast
// Initial revision
//
//
#include "BLGeneric.inc"

#declare lightFur = 
texture {
  pigment {color rgb <0.4,1,0.4>}
  normal {
    granite 
    scale 0.2
  }
}
#declare darkFur = 
texture {
  pigment {color rgb <0,0.6,0>}
  normal {
    granite 
    scale 0.2
  }
}

#declare eyeTexture = texture {
  pigment {
    wood
    color_map {
      [0.0 color Black]
      [0.5 color Black]
      [0.5 color White]
      [1.00 color White]
    }
  }
  finish {Shiny}
}
#declare noseTexture = texture {
  pigment {color Gray20}
  finish {Dull}
}

#declare leg = 
union {
  sphere {
    <0,0,0>, 1
    scale 0.3
  }
  cylinder { 
    <0,0,0>, <0,0,-0.75>,  0.3
  }
  sphere   { 
    <0,0,0>, 1
    scale <0.3,0.45,0.225>
    translate <0,0,-0.75>
  }
  sphere   { 
    <0,0,0>, 1
    scale <0.2625,0.4125,0.1875>
    translate <0,0,-0.825>
    texture {lightFur}
  }
}

#declare arm = 
union {
  sphere {
    <0,0,0>, 1
    scale 0.25
  }
  cylinder { 
    <0,0,0>, <0,0,-0.6>,  0.25
  }
  sphere   { 
    <0,0,0>, 1
    scale <0.30,0.25,0.30>
    translate <0,0,-0.6>
  }
  sphere   { 
    <0,0,0>, 1
    scale <0.25,0.20,0.25>
    translate <0,-0.1,-0.6>
    texture {lightFur}
  }
}


#declare belly = 
union {
  sphere {
    <0,0,0>, 1
    scale <0.6,0.8,0.4>
  }
  sphere {
    <0,0,0>, 1
    scale <0.5,0.65,0.35>
    translate <0,-0.05,-0.1>
    texture {lightFur}
  }
}

#declare head =
union {
  sphere {
    <0,0,0>, 1
    scale <0.8,0.6,0.6>
  }
  // mouth
  sphere {
    <0,0,0>, 1
    scale <0.5,0.4,0.65>
    translate <0,-0.2,-0.2>
    texture {lightFur}
  }
  // ears
  sphere {
    <0,0,0>, 1
    scale <0.2,0.2,0.1>
    translate <0.6,0.5,0.1>
  }
  sphere {
    <0,0,0>, 1
    scale <0.2,0.2,0.1>
    translate <-0.6,0.5,0.1>
  }
  // nose
  sphere {
    <0,0,0>, 1
    scale <0.15,0.15,0.15>
    translate <0,-0.1,-0.85>
    texture {noseTexture}
  }
  // left eye
  intersection {
    sphere {
      <0,0,0>, 1
      scale <0.81,0.61,0.61>
    }
    cylinder {
      <0,0,0>, <0,0,-1>, 1
      scale <0.15,0.2,1>
      translate <-0.25,0.15,0>
    }
    texture {
      eyeTexture 
      scale <0.4,0.6,1> 
      translate <-0.25,0.1,0>
    }
  }
  // right eye
  intersection {
    sphere {
      <0,0,0>, 1
      scale <0.81,0.61,0.61>
    }
    cylinder {
      <0,0,0>, <0,0,-1>, 1
      scale <0.15,0.2,1>
      translate <0.25,0.15,0>
    }
    texture {
      eyeTexture 
      scale <0.4,0.6,1> 
      translate <0.25,0.1,0>
    }
  }
}

union {
  // left left
  object {
    leg
    rotate y*20
    translate <-0.375,0,0>
//   rotate x*-90
  }
  // right left
  object {
    leg
    rotate y*-20
    translate <0.375,0,0>
//    rotate x*-90
  }
  // left arm
  object {
    arm 
    rotate z*90
    rotate y*90
    translate <-0.375,1.5,0>
  }
  // right arm
  object {
    arm 
    rotate -z*90
    rotate -y*90
    translate <0.375,1.5,0>
  }
  // belly
  object {
    belly
    translate <0,0.9,0>
  }
  // head
  object {
    head
    translate <0,2.2,0>
  }
  texture {darkFur}
  rotate x*90
  translate <0,0.4,-1.5>
}



// floor
plane {
  y, -0.1
  pigment {color rgb <0.2,0.2,0.2>}
}

#declare largeTile =
sphere {
  <0,0,0>, 1
  scale <0.7,0.1,0.7>
  translate <0,-0.1,0>
  pigment {color rgb <1,0,0>}
  finish {myShiny}
}
#declare smallTile =
sphere {
  <0,0,0>, 1
  scale <0.3,0.1,0.3>
  translate <0,-0.1,0>
  pigment {color rgb <0.5,0,0>}
  finish {myShiny}
}

union {
#declare XP=-4
#while (XP<=4)
   #declare YP=-4
   #while (YP<=4)
     object {largeTile translate <XP,0,YP>}
     object {largeTile translate <XP+1,0,YP+1>}
     object {smallTile translate <XP+1,0,YP>}
     object {smallTile translate <XP,0,YP+1>}
     #declare YP=YP+2
   #end
   #declare XP=XP+2
#end
}
