//
// pov file for rendering all players in all animations
//
// Program XBLAST V2.6 or higher
// (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2; or (at your option)
// any later version
//
// This program is distributed in the hope that it will be entertaining,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.
// 675 Mass Ave, Cambridge, MA 02139, USA.
//
//
#include "colors.inc"
#include "textures.inc"

#declare myClock = int((4 * 10 - 1)*clock + 0.5) 
// 4 shots of each animation
// 10 pictures loosing 3x, winning 3x, killed 4x
#warning concat("\nInternal Clock ",str(myClock,4,3),"\n")

#declare frameClock = mod(div(myClock,4),10)

#switch (frameClock)
  #range(0,2)
    // loosing
    #declare playerDamaged = 0
    #declare leftLowerArmAngle  = <  -15,   0, -30>
    #declare leftArmAngle       = <    0,   0, -60>
    #declare rightLowerArmAngle = <  -15,   0,  30>
    #declare rightArmAngle      = <    0,   0,  60>
    #declare rightLowerLegAngle = < - 25,   0,  0>
    #declare rightLegAngle      = < + 25,  15,  0>
    #declare leftLowerLegAngle  = < - 25,   0,  0>
    #declare leftLegAngle       = < + 25, -15,  0>
    #declare rightFootAngle     = <    0,   0,  0>
    #declare leftFootAngle      = <    0,   0,  0>
    #switch (frameClock)
       #case (0) 
         #declare headAngle          = <  -10,   0,  0>
       #break
       #case (1) 
         #declare headAngle          = <  -10,  15,  0>
       #break
       #case (2) 
         #declare headAngle          = <  -10, -15,  0>
       #break
    #end
    #declare bodyAngle          = <  -10,   0,  0>
    #declare zPos=-2.667
    #declare yAngle = 0.0
  #break
  #range(3,5)
    #switch (frameClock)
      #case (3)
        #declare W=0
      #break
      #case (4)
        #declare W=0.25
      #break
      #case (5)
        #declare W=0.75
      #break
    #end 
    // winning
    #declare playerDamaged = 0
    #declare leftLowerArmAngle  = <   30-45*W,  75-75*W,   0-30*W>
    #declare leftArmAngle       = <   75-60*W, -30+40*W, -15-30*W>
    #declare rightLowerArmAngle = <   30-45*W, -75+75*W,   0+30*W>
    #declare rightArmAngle      = <   75-60*W,  30-40*W,  15+30*W>
    #declare rightLowerLegAngle = <    0-25*W,   0     ,   0     >
    #declare rightLegAngle      = <    0+15*W,  15     ,   0     >
    #declare leftLowerLegAngle  = <    0-25*W,   0     ,   0     >
    #declare leftLegAngle       = <    0+15*W, -15     ,   0     >
    #declare rightFootAngle     = <    0     ,   0     ,   0     >
    #declare leftFootAngle      = <    0     ,   0     ,   0     >
    #declare headAngle          = <   10-10*W,   0     ,   0     >
    #declare bodyAngle          = <   10-10*W,   0     ,   0     >
    #declare zPos=-2.567-0.1*W
    #declare yAngle = 0.0
  #break
  #range(6,9)
    // killed
    #declare playerDamaged = 1
    #declare leftLowerArmAngle  = <  -15,   0, -30>
    #declare leftArmAngle       = <  -15, -20, -45>
    #declare rightLowerArmAngle = <  -15,   0,  30>
    #declare rightArmAngle      = <  -15,  20,  45>
    #declare rightLowerLegAngle = < - 25,   0,  0>
    #declare rightLegAngle      = < + 90,  15,  0>
    #declare leftLowerLegAngle  = < - 25,   0,  0>
    #declare leftLegAngle       = < + 90, -15,  0>
    #declare rightFootAngle     = <    0,   0,  0>
    #declare leftFootAngle      = <    0,   0,  0>
    #declare headAngle          = <    0,   0, 10>
    #declare bodyAngle          = <   15,   0,  0>
    #declare zPos=-2.667
    #declare playerWalkHeight   = -1.0
    #declare yAngle = (frameClock-6) * 90
  #break
#end

#declare playerClock=mod(myClock,4)

#switch (playerClock)
  #case (0)
    #include "Player A.inc"
  #break
  #case (1)
    #include "Player B.inc"
  #break
  #case (2)
    #include "Player C.inc"
  #break
  #case (3)
    #include "Player D.inc"
  #break
#end
object {Player rotate y*yAngle translate z*zPos}

// draw floor
plane {
  y, 0
  #if (mod(myClock,4) != 3)
    pigment {color rgb <0.333,0.333,0.333>}
  #else
    pigment {color rgb <1,1,1>}
  #end
  finish {ambient 0.0 diffuse 1.0}
}

// background (sky) color
background {color SkyBlue}



// light source
light_source {
  <-100,500,-250>
  color rgb <1.2,1.2,1.2>
}

// camera
#declare Entf = 500.0
camera
{
  location  <0, 0, -Entf>
  direction <0, 0,  Entf>
  up        6.0*y
  right     4.0*x
  look_at   <0.0, 0.0, 0.0>
  rotate x*48.60
}





