/*
 * Program XBLAST V2.5.15 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * October 18, 1998
 * started August 1993
 *
 * File: image.h
 * header file for image.c
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: image.h,v 1.2 1998/10/18 12:30:04 xblast Exp $
 * $Log: image.h,v $
 * Revision 1.2  1998/10/18 12:30:04  xblast
 * Morphing Bomb extra
 *
 * Revision 1.1  1998/01/03 14:10:50  xblast
 * Initial revision
 *
 */
#ifndef _IMAGE_H
#define _IMAGE_H

/*
 * some image data types 
 */

/* normal rgb images */
typedef struct {
  char *bits;
} NormalImageData;

/* masked images (explosions, bombs) */
typedef struct {
  char *mask;
  char *bits;
} MaskedImageData;


/* player images (player sprites) */
typedef struct {
  int always;
  char *mask;
  char *bits[MAX_PLAYER];
} PlayerImageData;

/* extended image data (ppm or epm) */
typedef struct {
  int is_epm;
  int always;
  char *bits;
} ExtendedImageData;

/* 
 * some constants 
 */

#define MAX_EXPLOSION 16
#define MAX_BOMBS 2
#define MAX_ANIME_BITS 18

/*
 * external variables
 */
#ifndef _IMAGE_C
extern NormalImageData title_data, text_bg_data, text_fg_data;
extern NormalImageData score_led_data[2];
extern NormalImageData score_tile_data[];
extern NormalImageData score_bitmap_data[];
extern NormalImageData score_player_data[];
extern MaskedImageData expl_data[MAX_EXPLOSION];
extern MaskedImageData bomb_bitmap_data[MAX_BOMBS];
extern NormalImageData bomb_image_data[MAX_BOMBS][MAX_BOMB_ANIME];
extern int sprite_bitmap_table[MAX_ANIME];
extern BMRectangle sprite_bitmap_size[MAX_ANIME_BITS];
extern BMRectangle sprite_image_size[MAX_ANIME];
extern PlayerImageData sprite_bitmap[MAX_ANIME_BITS];
extern ExtendedImageData sprite_image[MAX_ANIME];
#endif

#endif
/*
 * end of file image.h
 */
