#ifndef MATHUTIL_H
#define MATHUTIL_H


#include "objects.h"



extern double RADTODEG(double radians);
extern double DEGTORAD(double degrees);
extern double SANITIZERADIANS(double radians);
extern double SANITIZEDEGREES(double degrees);

extern double MuPolarRotX(double theta, double r);
extern double MuPolarRotY(double theta, double r);

extern void MuVectorAdd(
        double v1_dir, double v1_mag,
        double v2_dir, double v2_mag,
        double *v_dir_rtn, double *v_mag_rtn
);
extern double MuCoordinateDeltaVector(double dx, double dy);
extern double Mu3DDistance(double dx, double dy, double dz);

extern int Mu3DInSector(
	long object_num,
	long sect_x,
	long sect_y,
	long sect_z
);
extern int Mu3DInSameSector(long object_num1, long object_num2);
extern int Mu3DInSameSectorPtr(
        xsw_object_struct *obj1_ptr,
        xsw_object_struct *obj2_ptr
);
extern int Mu3DInContact(long object_num1, long object_num2);
extern int Mu3DInContactPtr(
        xsw_object_struct *obj1_ptr,
        xsw_object_struct *obj2_ptr
);
extern int Mu3DInVectorContact(
        long object_num1,
        long object_num2,
        double heading,
        double heading_variance,
        double range
);
extern int Mu3DInRange(long object_num1, long object_num2, double distance);
extern int Mu3DInRangePtr(
        xsw_object_struct *obj1_ptr,
        xsw_object_struct *obj2_ptr,
        double distance
);
extern double MuMaxRangeByVelocity(double v_max, long t);




#endif	/* MATHUTIL_H */
