#include "swserv.h"


/*
 *      Prints object's score.
 */
int CmdScore(int condescriptor, char *arg)
{
        long object_num;
        char name[XSW_OBJ_NAME_MAX];
        char sndbuf[CS_DATA_MAX_LEN]; 
	xsw_object_struct *obj_ptr;


        /* Copy arg to name. */
        strncpy(name, arg, XSW_OBJ_NAME_MAX);
        name[XSW_OBJ_NAME_MAX - 1] = '\0';   
        StringStripSpaces(name);


        /* If no argument, assume connection's object. */
        if(name[0] == '\0')
            object_num = connection[condescriptor]->object_num;
	else if(!strcmp(name, "me"))
	    object_num = connection[condescriptor]->object_num;
        else
            object_num = MatchObjectByName(name, -1);


        /* Make sure object_num is valid. */
        if(DBIsObjectGarbage(object_num))   
        {
            sprintf(sndbuf, "%s: No such object.", name);
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }
	else
	{
	    obj_ptr = xsw_object[object_num];
	}

	strncpy(name, obj_ptr->name, XSW_OBJ_NAME_MAX);
	name[XSW_OBJ_NAME_MAX - 1] = '\0';


        /* Does object have scores? */
        if(obj_ptr->score == NULL)
        {
            sprintf(sndbuf, "%s: No scores.", name);
        }
	else
	{
            sprintf(sndbuf,
 "%s: Credits: %.2lf  RMU: %.2lf(%.2lf)  DmgGiv: %.2lf  DmgRec: %.2lf\
  Kills: %ld",
                DBGetFormalNameStr(object_num),
                obj_ptr->score->credits,
                obj_ptr->score->rmu,
                obj_ptr->score->rmu_max,
                obj_ptr->score->damage_given,
                obj_ptr->score->damage_recieved,
                obj_ptr->score->kills
            );
	}
        NetSendLiveMessage(condescriptor, sndbuf);


        return(0);
}
