#include "swserv.h"


/*
 *	Shows players connected.
 */
int CmdWho(int condescriptor, char *arg)
{
	int i, c;
	connection_struct **ptr;
        long object_num;
        long object_con;

        char sndbuf[CS_DATA_MAX_LEN];


	/* Use default argument if NULL. */
	if(arg == NULL)
	    arg = "";

	/* Skip leading spaces. */
        while(*arg == ' ')
	    arg++;


        /* Print all connections? */
        if(*arg == '\0')
        {
            for(i = 0, c = 0, ptr = connection;
                i < total_connections;
                i++, ptr++
	    )
            {
                if(*ptr == NULL)
                    continue;

		if((*ptr)->socket < 0)
		    continue;

                object_num = (*ptr)->object_num;
                if(DBIsObjectGarbage(object_num))
                    continue;

                /* Format sndbuf. */
		sprintf(
		    sndbuf,
		    "%s  %i  %s  %s",
                    DBGetFormalNameStr(object_num),
                    (*ptr)->client_type,
                    StringFormatTimePeriod(
                        cur_systime - (*ptr)->contime
                    ),
		    (((*ptr)->is_guest) ? "Guest" : "")
		);
                sndbuf[CS_DATA_MAX_LEN - 1] = '\0';
                NetSendLiveMessage(condescriptor, sndbuf);

                /* Increment c, connected players. */
                c++;
            }


            /* Print footer. */
            sprintf(
		sndbuf,
		"*** %i player%s connected. ***",
                c,
		((c == 1) ? "" : "s")
            );
            sndbuf[CS_DATA_MAX_LEN - 1] = '\0'; 
            NetSendLiveMessage(condescriptor, sndbuf);
        }
        /* Print all connections with host names. */   
        else if(!strcasecmp(arg, "*"))
        {
            for(i = 0, c = 0, ptr = connection;
                i < total_connections;
                i++, ptr++
            )
            {
                if(*ptr == NULL)
                    continue;
                    
                if((*ptr)->socket < 0)
                    continue;

                object_num = (*ptr)->object_num;
                if(DBIsObjectGarbage(object_num))
                    continue;

                /* Format sndbuf. */  
                sprintf(  
                    sndbuf,
                    "%s  %i  %s  %s",
                    DBGetFormalNameStr(object_num),
                    (*ptr)->client_type,
                    (*ptr)->conhost,
                    (((*ptr)->is_guest) ? "Guest" : "")
                );
                sndbuf[CS_DATA_MAX_LEN - 1] = '\0';
                NetSendLiveMessage(condescriptor, sndbuf);

                /* Increment c, connected players. */
                c++;
            }

            /* Print footer. */
            sprintf(
                sndbuf,
                "*** %i player%s connected. ***",
                c,
                ((c == 1) ? "" : "s")
            );
            sndbuf[CS_DATA_MAX_LEN - 1] = '\0';
            NetSendLiveMessage(condescriptor, sndbuf);
        }
        /* Print specific player. */
        else
        {
            object_num = MatchObjectByName(arg, XSW_OBJ_TYPE_PLAYER);
            if(DBIsObjectGarbage(object_num))
            {               
                sprintf(sndbuf,
                    "who: %s: No such player.", 
                    arg
                );
                NetSendLiveMessage(condescriptor, sndbuf);   
                return(-1);
            }

            /* Is object_num connected? */
            for(i = 0, object_con = -1, ptr = connection;
                i < total_connections;
                i++, ptr++
            )
            {
                if(*ptr == NULL)
                    continue;
         
                if((*ptr)->socket < 0)
                    continue;

                if((*ptr)->object_num == object_num)
                {
                    object_con = i;
                    break;
                }
            }

            /* Check if we found a connection for the object. */
            if((object_con < 0) || (object_con >= total_connections))
            {
                sprintf(sndbuf,  
                    "who: %s: Not connected.",
                    arg
                );
                NetSendLiveMessage(condescriptor, sndbuf);

                return(-1);
            }
            if(connection[object_con] == NULL)
	    {
                sprintf(sndbuf,
                    "who: %s: Not connected.",
                    arg
                );
                NetSendLiveMessage(condescriptor, sndbuf);
                
                return(-1);  
	    }

            /* Print player. */
	    sprintf(
		sndbuf,
		"%s  %i  %s  %s",
		DBGetFormalNameStr(object_num),
                connection[object_con]->client_type,
                StringFormatTimePeriod(
                    cur_systime - connection[object_con]->contime
                ),
                ((connection[object_con]->is_guest) ? "Guest" : "")
            );
            sndbuf[CS_DATA_MAX_LEN - 1] = '\0';
            NetSendLiveMessage(condescriptor, sndbuf);
        }


        return(0);
}
