// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLDynamicLoader.C

  Stephane Rehel
  March 30 1998
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "tools/MLString.h"
#include "tools/MLDynamicLibrary.h"
#include "tools/MLPath.h"
#include "tools/MLPathList.h"

#include "MLKernel.h"

#include "MLDynamicLoader.h"

/////////////////////////////////////////////////////////////////////////////

MLDynamicLoader::MLDynamicLoader()
{
  dl= 0;
  errorMessage= "";
}

/////////////////////////////////////////////////////////////////////////////

MLDynamicLoader::~MLDynamicLoader()
{
  delete dl; // close it
  dl= 0;
}

/////////////////////////////////////////////////////////////////////////////

boolean MLDynamicLoader::load( MLKernel* kernel,
                               const MLString& _la_filename )
{
  errorMessage= "";
  full_lib_filename= "";

  delete dl;
  dl= new MLDynamicLibrary;

  MLString full_path("");

  char* ld_library_path= getenv("LD_LIBRARY_PATH");
  if( ld_library_path != 0 )
    full_path+= MLString(ld_library_path) + MLString(":");

  full_path+= kernel->getInstallExecPrefix() + MLString("lib/moonlight");

  if( kernel->verbose() )
    fprintf( stderr, "searching for plug-ins in %s\n", full_path.get() );

  MLPathList pl(full_path);
  MLPath* path= pl.findFile(_la_filename);
  if( path == 0 )
    {
    errorMessage= MLString("unable to find file ") + _la_filename;
    return 0;
    }

  // Can you feel it, now that spring has come!
  MLString la_filename= MLString(path->get()) + _la_filename;
  MLString filename= "";
  FILE* file= fopen( la_filename.get(), "r" );
  if( file == 0 )
    {
    errorMessage= MLString("unable to open file ") + la_filename;
    return 0;
    }
  // We are searching for the following lines:
  //
  // # The name that we can dlopen(3).
  // dlname='libmoon_tcl.so.0'
  //
  // and we set filename to libmoon_tcl.so.0
  for(;;)
    {
    char line[1024];
    if( fgets(line,1023,file) == 0 )
      break;
    MLString l1= MLString(line,0,7);
    if( l1 != MLString("dlname=") )
      continue;
    MLString l(line);
    int i1= l.indexOf('\'');
    int i2= l.indexOf('\'',i1+1);
    if( i1 == -1 || i2 == -1 )
      continue;
    // found it
    filename= l.substring(i1+1,i2-1);
    break;
    }
  fclose(file);
  file= 0;

  if( filename.length() == 0 )
    {
    errorMessage= MLString("unable to find dlname in ")+la_filename;
    delete dl;
    dl= 0;
    return 0;
    }


#ifndef NDEBUG
  MLString save_filename= filename;
  filename= path->get() + filename;
  if( getenv("MOONLIGHT_DEV") != 0 )
    {
    if( access(filename.get(),R_OK) != 0 )
      filename= path->get() + MLString(".libs/") + save_filename;
    }
#else
  filename= path->get() + filename;
#endif

  full_lib_filename= filename;

  if( ! dl->open(filename) )
    {
    errorMessage= dl->getErrorMessage();
    delete dl;
    dl= 0;
    return 0;
    }

  return true;
}

/////////////////////////////////////////////////////////////////////////////

MLString MLDynamicLoader::getErrorMessage()
{
  MLString em= errorMessage;
  errorMessage= "";
  return em;
}

/////////////////////////////////////////////////////////////////////////////
