// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLOperator.h

  Stephane Rehel
  March 24 1998
*/

#ifndef __MLOperator_h
#define __MLOperator_h

#include "tools/MLArray.h"

#include "MLNode.h"

class MLProperty;

/////////////////////////////////////////////////////////////////////////////

class MLOperator: public MLNode
{
protected:
  // the properties used by this operator
  MLArray<MLProperty*> sourceProps;

  // the properties generated by this operator
  MLArray<MLProperty*> destProps;

  // true if some source props have changed
  boolean need_to_be_updated;

  // true if this operator is currently beeing updated (this is for
  // avoiding infinite loops)
  boolean beeing_updated;

public:
  MLOperator( MLNode* _parent );

  virtual ~MLOperator();

  virtual MLNodeType::Type getNodeType() const
    {
    return MLNodeType::OPERATOR;
    }

  const MLArray<MLProperty*>& getSourceProps() const
    {
    return sourceProps;
    }

  const MLArray<MLProperty*>& getDestProps() const
    {
    return destProps;
    }

  void to_be_updated()
    {
    need_to_be_updated= true;
    }

  // this is for operators dependencies
  void tree_to_be_updated();

  // you should first call tree_to_be_updated() on all the operators
  // before calling this function
  boolean update( boolean& needed );

  // return false if an error occurs
  // needed: true if this operator really needed to be updated
  // it is _not_ recursive: it assumes sourcesProps are up to date
  virtual boolean _update( boolean& needed ) = 0;

  void addSourceProp( MLProperty* p );

  void removeSourceProp( MLProperty* p );

  void addDestProp( MLProperty* p );

  void removeDestProp( MLProperty* p );

  // return true if at least one operator needs to be updated
  static boolean check_updating( MLArray<MLOperator*>& ops );

  // return true if at least one operator has been updated
  static boolean update( MLArray<MLOperator*>& ops );
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __MLOperator_h
