// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
   OStringHashTable.h

   OString Hash Table

   Stephane Rehel [SCFR::Kepler] Stephane.Rehel@imag.fr
   August 1995
*/

#ifndef __OStringHashTable_h
#define __OStringHashTable_h

#ifndef __HashTable_h
#include "HashTable.h"
#endif

#ifndef __OString_h
#include "OString.h"
#endif

/////////////////////////////////////////////////////////////////////////////

class OStringHashTable: public HashTable<OString>
{
public:
  OStringHashTable(): HashTable<OString>()
    {}

  virtual ~OStringHashTable()
    {}

  HashCode getHashCode( const char* strg ) const;

  HashCode getHashCode( const OString* t ) const
    {
    return getHashCode( t->get() );
    }

  boolean equal( const OString* t1, const OString* t2 ) const
    {
    return *t1 == *t2;
    }

  // return created OString
  OString* addNew( const char* string )
    {
    return addNew( string, getHashCode(string) );
    }

  // return 0 if not found
  OString* find( const char* string )
    {
    return find( string, getHashCode(string) );
    }

  // return 0 if not found and added
  // else return existing OString
  OString* addUnique( const char* string );

  // no error if not found
  // doesn't delete t
  void removeString( const char* string );

protected:
  OString* addNew( const char* string, HashCode hc );
  OString* find( const char* string, HashCode hc );
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __OStringHashTable_h

