/***************************************************************************
                          rfilebase.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rfilebase.h 1998/08/28 A. Mustun RibbonSoft 
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RFILEBASE_H
#define RFILEBASE_H

#include <qfile.h>

#include "rtypes.h"

class RStatusPanel;

class RFileBase : public QFile
{
public:
  RFileBase(const char* _name);
  ~RFileBase();

  void    reset();
  void    resetBufP();

  void    setBufP(int _fBufP);
  int     getBufP() { return fBufP; }
  void    delBuffer();
	void    dos2unix();

  char*   getBufLine();
  char*   getBuf() { return fBuf; }
  void    setBuf(char* _buf) { fBuf=_buf; }
  void    copyBufFrom(const char* _buf);
  bool    gotoBufLine(char* _lstr);
  bool    gotoBufLineString(char* _lstr);

  void    replaceBinaryBytesBy(char _c);
  void    seperateBuf(char _c1=13,
                      char _c2=10,
                      char _c3=0,
                      char _c4=0);
  void    removeComment(char _fc='(',
                        char _lc=')');

  bool    readFileInBuffer(char* _name, int _bNum=-1);
  bool    readFileInBuffer(int _bNum=-1);

  bool    saveBufferToFile(char* _name);
  bool    saveBufferToFile();

  RStatusPanel* statusPanel();


protected:
  FILE*   fPointer;         // File pointer
  char*   fBuf;      // Filebuffer
  int     fBufP;            // Filebuffer-Pointer (walks through 'fBuf')  
  uint    fSize;            // Filesize
    
private:

};


#endif

// EOF



