/***************************************************************************
                          rfontdialog.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rfontdialog.cpp 1998/09/03 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <qdir.h>
#include <qkeycode.h>
#include <qlayout.h>
#include <qframe.h>
#include <qmessagebox.h>
#include <qpixmap.h>
#include <qradiobutton.h>
#include <qscrollview.h>
#include <qstring.h>
#include <qtooltip.h>
#include <qvalidator.h>

#include "rbuttongroup.h"
#include "rcheckbox.h"
#include "rcombobox.h"
#include "rfontdialog.h"
#include "rfonts.h"
#include "rgraphic.h"
#include "rgroupbox.h"
#include "rconfig.h"
#include "rlabel.h"
#include "rlog.h"
#include "rlineedit.h"
#include "rmultilinedit.h"
#include "rpushbutton.h"
#include "rradiobutton.h"
#include "rstring.h"
#include "rtoolbutton.h"

#include "rxpmtext.h"


// Constructor:
//
RFontDialog::RFontDialog(RGraphic* _graphic,
                         QWidget* _parent,
                         const char *_name)
  :QDialog(_parent, _name, true, WStyle_NormalBorder)
{
  int r;      // Counter for row

  setCaption(DEF_APPNAME);

  graphic=_graphic;

  // Layout:
  //
  QGridLayout *gl = new QGridLayout(this, 5, 2, 7);
    gl->setColStretch(0, 2);
    gl->setColStretch(1, 3);

    //gl->setRowStretch(0, 3);
    gl->setRowStretch(0, 4);
    gl->setRowStretch(1, 30);
    gl->setRowStretch(2, 9);
    gl->setRowStretch(3, 9);
    gl->setRowStretch(4, 6);  // Formally: 4

  // Measures:
  //
  r=1;
  RGroupBox *gbMeas = new RGroupBox(RMES(306), this);
  gl->addMultiCellWidget(gbMeas, 0, 1, 0, 0);

    QGridLayout *glMeas = new QGridLayout(gbMeas, 9, 2, 8, 6);
    glMeas->setColStretch(0, 3);
    glMeas->setColStretch(1, 2);

    glMeas->setRowStretch(0, 1);
    glMeas->setRowStretch(1, 2);
    glMeas->setRowStretch(2, 2);
    glMeas->setRowStretch(3, 2);
    glMeas->setRowStretch(4, 2);
    glMeas->setRowStretch(5, 2);
    glMeas->setRowStretch(6, 2);
    glMeas->setRowStretch(7, 2);
    glMeas->setRowStretch(8, 2);

    // Proportional:
    //
    cbProportional = new RCheckBox(RMES(309), gbMeas);
    connect(cbProportional, SIGNAL(toggled(bool)), 
          this, SLOT(proportional(bool)));
    glMeas->addWidget(cbProportional, r, 0);
    ++r;

    // Text Height:
    //
    lTextHeight = new RLabel(RMES(310), gbMeas);
    glMeas->addWidget(lTextHeight, r, 0);
    eTextHeight = new RLineEdit(gbMeas);
    glMeas->addWidget(eTextHeight, r, 1);
    connect(eTextHeight, SIGNAL(textChanged(const QString&)), 
            this, SLOT(adjustValuesToTextHeight(const QString&)));
    ++r;

    // Letter Spacing:
    //
    lLetterSpacing = new RLabel(RMES(311), gbMeas);
    glMeas->addWidget(lLetterSpacing, r, 0);
    eLetterSpacing = new RLineEdit(gbMeas);
    glMeas->addWidget(eLetterSpacing, r, 1);
    ++r;

    // Word spacing:
    //
    lWordSpacing = new RLabel(RMES(312), gbMeas);
    glMeas->addWidget(lWordSpacing, r, 0);
    eWordSpacing = new RLineEdit(gbMeas);
    glMeas->addWidget(eWordSpacing, r, 1);
    ++r;

    // Line Distance:
    //
    lLineDistance = new RLabel(RMES(313), gbMeas);
    glMeas->addWidget(lLineDistance, r, 0);
    eLineDistance = new RLineEdit(gbMeas);
    glMeas->addWidget(eLineDistance, r, 1);
    ++r;

    // Angle:
    //
    lAngle = new RLabel(RMES(314), gbMeas);
    glMeas->addWidget(lAngle, r, 0);
    eAngle = new RLineEdit(gbMeas);
    glMeas->addWidget(eAngle, r, 1);
    ++r;

    // Radius:
    //
    lRadius = new RLabel(RMES(315), gbMeas);
    glMeas->addWidget(lRadius, r, 0);
    eRadius = new RLineEdit(gbMeas);
    glMeas->addWidget(eRadius, r, 1);
    ++r;

    // Fixed letter width:
    //
    cbFixedWidth = new RCheckBox(RMES(468), gbMeas);
    connect(cbFixedWidth, SIGNAL(toggled(bool)),
            this, SLOT(fixedWidth(bool)));
    glMeas->addMultiCellWidget(cbFixedWidth, r, r, 0, 1);


  // Alignment:
  //
  RButtonGroup *gbAlign = new RButtonGroup(RMES(307), this);
  gl->addWidget(gbAlign, 2, 0);

    QGridLayout *glAlign = new QGridLayout(gbAlign, 3, 5, 0);
    glAlign->setColStretch(0, 1);
    glAlign->setColStretch(1, 4);
    glAlign->setColStretch(2, 4);
    glAlign->setColStretch(3, 3);
    glAlign->setColStretch(4, 1);

    glAlign->setRowStretch(0, 2);
    glAlign->setRowStretch(1, 2);
    glAlign->setRowStretch(2, 1);

    rbAlignLeft = new RRadioButton(gbAlign);
    rbAlignLeft->setPixmap(QPixmap(alignleft_xpm));
    glAlign->addWidget(rbAlignLeft, 1, 1);

    rbAlignCenter = new RRadioButton(gbAlign);
    rbAlignCenter->setPixmap(QPixmap(aligncenter_xpm));
    glAlign->addWidget(rbAlignCenter, 1, 2);

    rbAlignRight = new RRadioButton(gbAlign);
    rbAlignRight->setPixmap(QPixmap(alignright_xpm));
    glAlign->addWidget(rbAlignRight, 1, 3);

  // Shape:
  //
  RButtonGroup *gbShape = new RButtonGroup(RMES(308), this);
  gl->addWidget(gbShape, 3, 0);

    QGridLayout *glShape = new QGridLayout(gbShape, 3, 5, 0);
    glShape->setColStretch(0, 1);
    glShape->setColStretch(1, 4);
    glShape->setColStretch(2, 4);
    glShape->setColStretch(3, 3);
    glShape->setColStretch(4, 1);

    glShape->setRowStretch(0, 2);
    glShape->setRowStretch(1, 2);
    glShape->setRowStretch(2, 1);

    rbShapeStraight = new RRadioButton(gbShape);
    rbShapeStraight->setPixmap(QPixmap(shapestraight_xpm));
    glShape->addWidget(rbShapeStraight, 1, 1);

    rbShapeRoundIn = new RRadioButton(gbShape);
    rbShapeRoundIn->setPixmap(QPixmap(shaperoundin_xpm));
    glShape->addWidget(rbShapeRoundIn, 1, 2);

    rbShapeRoundOut = new RRadioButton(gbShape);
    rbShapeRoundOut->setPixmap(QPixmap(shaperoundout_xpm));
    glShape->addWidget(rbShapeRoundOut, 1, 3);

  // Text field tools:
  //
  QWidget* wTools = new QWidget(this);
  gl->addWidget(wTools, 0, 1);

    QGridLayout *glTools = new QGridLayout(wTools, 1, 9, 2);
    glTools->setColStretch(0, 6);
    glTools->setColStretch(1, 8);
    glTools->setColStretch(2, 3);
    glTools->setColStretch(3, 3);
    glTools->setColStretch(4, 3);
    glTools->setColStretch(5, 1);
    glTools->setColStretch(6, 3);
    glTools->setColStretch(7, 3);
    glTools->setColStretch(8, 3);
    
    lText = new RLabel(RMES(316), wTools);
    glTools->addWidget(lText, 0, 0);

    bNew = new RToolButton(wTools);
    bNew->setPixmap(QPixmap(filenew_xpm));
    QToolTip::add(bNew, RMES(317));
    connect(bNew, SIGNAL(clicked()), this, SLOT(clearText()));
    glTools->addWidget(bNew, 0, 2);

    bLoad = new RToolButton(wTools);
    bLoad->setPixmap(QPixmap(fileopen_xpm));
    QToolTip::add(bLoad, RMES(318));
    connect(bLoad, SIGNAL(clicked()), this, SLOT(loadText()));
    glTools->addWidget(bLoad, 0, 3);

    bSave = new RToolButton(wTools);
    bSave->setPixmap(QPixmap(filesave_xpm));
    QToolTip::add(bSave, RMES(319));
    connect(bSave, SIGNAL(clicked()), this, SLOT(saveText()));
    glTools->addWidget(bSave, 0, 4);

    fSep1 = new QFrame(wTools);
    fSep1->setFrameStyle(fSep1->VLine|fSep1->Sunken);
    glTools->addWidget(fSep1, 0, 5);

    bCut = new RToolButton(wTools);
    bCut->setPixmap(QPixmap(cut_xpm));
    QToolTip::add(bCut, RMES(320));
    connect(bCut, SIGNAL(clicked()), this, SLOT(cutText()));
    glTools->addWidget(bCut, 0, 6);

    bCopy = new RToolButton(wTools);
    bCopy->setPixmap(QPixmap(copy_xpm));
    QToolTip::add(bCopy, RMES(321));
    connect(bCopy, SIGNAL(clicked()), this, SLOT(copyText()));
    glTools->addWidget(bCopy, 0, 7);

    bPaste = new RToolButton(wTools);
    bPaste->setPixmap(QPixmap(paste_xpm));
    QToolTip::add(bPaste, RMES(322));
    connect(bPaste, SIGNAL(clicked()), this, SLOT(pasteText()));
    glTools->addWidget(bPaste, 0, 8);


  // Text field:
  //
  meText = new RMultiLineEdit(this);
  gl->addMultiCellWidget(meText, 1, 2, 1, 1);

  // Font:
  //
  RGroupBox *gbFont = new RGroupBox(RMES(325), this);
  gl->addWidget(gbFont, 3, 1);

    QGridLayout *glFont = new QGridLayout(gbFont, 3, 3, 0);
    glFont->setColStretch(0, 1);
    glFont->setColStretch(1, 12);
    glFont->setColStretch(2, 1);

    glFont->setRowStretch(0, 4);
    glFont->setRowStretch(1, 5);
    glFont->setRowStretch(2, 2);

    cbFont = new RComboBox(gbFont);
    cbFont->fillInFonts();
    connect(cbFont, SIGNAL(activated(int)), this, SLOT(fontChanged(int)));
    glFont->addWidget(cbFont, 1, 1);

  // Main Buttons:
  //
  // OK:
  //
  bOk = new RPushButton(RMES(46), this);
  bOk->setAccel(ALT|Key_Return);
  connect(bOk, SIGNAL(clicked()), SLOT(accept()));

  // Cancel:
  //
  bCancel = new RPushButton(RMES(47), this);
  bCancel->setAccel(Key_Escape);
  connect(bCancel, SIGNAL(clicked()), SLOT(reject()));

  // Help:
  //
  /*
  bHelp = new RPushButton(RMES(48), this);
  bHelp->setAccel(Key_F1);
  */


  setMinimumSize(DEF_MINFONTDLGWIDTH, DEF_MINFONTDLGHEIGHT);

  // Resize / Move by values set in INI-File:
  //
  int w = RCONFIG->getSettingInt( "Application:FontDialogWindowWidth" );
  int h = RCONFIG->getSettingInt( "Application:FontDialogWindowHeight" );

  if(w>0 && h>0) {
    resize( w,h );
  }

  int x = RCONFIG->getSettingInt( "Application:FontDialogWindowX" );
  int y = RCONFIG->getSettingInt( "Application:FontDialogWindowY" );
  
  if(x>-100 && y>-100    ) {
    move( x,y );
  }

  // Set data from graphic:
  //
  if(_graphic) {
    setDataFromGraphic();
  }
  
  text="";
  
  RLOG("\nRFontDialog created successfully");
}



// Destructor:
//
RFontDialog::~RFontDialog()
{

}



// Set dialogs data from graphic:
//
bool
RFontDialog::setDataFromGraphic()
{
  bool ret=false;
  RLOG("\nSet Font Dialog Data from Graphic");

  if(graphic) {
  
    // Set proportional flag:
    //
    cbProportional->setChecked(graphic->getFontProportional());
    
    // Fill lineedits with standard values from graphic doc:
    //
    eTextHeight->setFloat(graphic->getFontHeight());
    eLetterSpacing->setFloat(graphic->getFontLetterSpacing());
    eWordSpacing->setFloat(graphic->getFontWordSpacing());
    eLineDistance->setFloat(graphic->getFontLineDistance());
    eAngle->setFloat(graphic->getFontAngle());
    eRadius->setFloat(graphic->getFontRadius());

    // Set fixed width flag:
    //
    cbFixedWidth->setChecked(graphic->getFontFixedWidth());
    
    // Set alignment:
    //
    if(graphic->getFontFlags()->getFlag(E_RIGHT)) {
      rbAlignRight->setChecked(true);
    }
    else if(graphic->getFontFlags()->getFlag(E_CENTER)) {
      rbAlignCenter->setChecked(true);
    }
    else {
      rbAlignLeft->setChecked(true);
    }
    
    // Set shape:
    //
    if(graphic->getFontFlags()->getFlag(E_ROUNDOUT)) {
      rbShapeRoundOut->setChecked(true);
    }
    else if(graphic->getFontFlags()->getFlag(E_ROUNDIN)) {
      rbShapeRoundIn->setChecked(true);
    }
    else {
      rbShapeStraight->setChecked(true);
    }
    
    // Set Font:
    //
    RFonts* fonts = RFonts::getRFonts();
    int     fontNumber = graphic->getFontNumber();
    if(fonts->isFontValid(fontNumber)) {
      cbFont->setEditText(fonts->getFontName(fontNumber));
    }
    
  }

  return ret;
}



// Set text from extern:
//
void 
RFontDialog::setText(const char* _text)
{
  if(_text) {
    meText->setText(_text);
  }
}



// Slot accept:
//
void 
RFontDialog::accept()
{
  RLOG("\nAccept");

  // Catch too small radius:
  //
  if(rbShapeRoundOut->isChecked() || rbShapeRoundIn->isChecked()) {
    if(eRadius->getFloat()<0.001) {
      QMessageBox::warning( this, DEF_APPNAME,
                            RMES(450),
                            QMessageBox::Ok | QMessageBox::Default,
                            0 );
      return;
    }
  }

  if(graphic) {

    // Set proportional flag:
    //
    graphic->setFontProportional(cbProportional->isChecked());

    // Set new values for graphic doc from user input:
    //
    graphic->setFontHeight(eTextHeight->getFloat());
    graphic->setFontLetterSpacing(eLetterSpacing->getFloat());
    graphic->setFontWordSpacing(eWordSpacing->getFloat());
    graphic->setFontLineDistance(eLineDistance->getFloat());
    graphic->setFontAngle(eAngle->getFloat());
    graphic->setFontRadius(eRadius->getFloat());

    // Set fixed width flag:
    //
    graphic->setFontFixedWidth(cbFixedWidth->isChecked());

    // Temporary text flags:
    //
    uint alignFlags=0;
    uint shapeFlags=0;
    uint miscFlags=0;

    // Set new alignment from user input:
    //
    if(rbAlignRight->isChecked()) {
      alignFlags=E_RIGHT;
    }
    else if(rbAlignCenter->isChecked()) {
      alignFlags=E_CENTER;
    }
    else {
      alignFlags=E_LEFT;
    }


    // Set new shape from user input:
    //
    if(rbShapeRoundOut->isChecked()) {
      shapeFlags=E_ROUNDOUT;
    }
    else if(rbShapeRoundIn->isChecked()) {
      shapeFlags=E_ROUNDIN;
    }
    else {
      shapeFlags=E_STRAIGHT;
    }

    // Misc flags (proportional, fixed width)
    //
    if(cbFixedWidth->isChecked()) {
      miscFlags|=E_FIXEDWIDTH;
    }
    if(cbProportional->isChecked()) {
      miscFlags|=E_PROPORTIONAL;
    }

    graphic->setFontFlags(alignFlags|shapeFlags|miscFlags);

    // Set new Font number:
    //
    RFonts* fonts = RFonts::getRFonts();
    graphic->setFontNumber(fonts->getFontNumber(cbFont->currentText()));
  }

  text = meText->text();

  QDialog::accept();
}



// Toggle / untoggle checkbox "Proportional":
//
void 
RFontDialog::proportional(bool _on)
{
  
  eLetterSpacing->setEnabled(!_on);
  eWordSpacing->setEnabled(!_on);
  eLineDistance->setEnabled(!_on);
  
  if(_on) {  
    adjustValuesToTextHeight(eTextHeight->text());
  }
}



// Toggle / untoggle checkbox "Fixed width":
//
void
RFontDialog::fixedWidth(bool _on)
{
  if(_on) meText->setFont( QFont("Courier") );
  else    meText->setFont( QFont("Arial") );

  // Qt bug (doesn't update fonts):
  //
  meText->setText( meText->text() );
}



// User has changed the font:
//
void
RFontDialog::fontChanged(int)
{
  adjustValuesToTextHeight(eTextHeight->text());
}



// Adjust Values "Word spacing, Letter spacing and line distance" 
//   to text height:
//
void 
RFontDialog::adjustValuesToTextHeight(const QString&)
{
  if(cbProportional->isChecked()) {
    
    RFonts* fonts = RFonts::getRFonts();
    int fontNumber = fonts->getFontNumber(cbFont->currentText());
    
    eLetterSpacing->setFloat( eTextHeight->getFloat() *
                              fonts->getFontLetterSpacingFactor(fontNumber));
    
    eWordSpacing->setFloat(   eTextHeight->getFloat() * 
                              fonts->getFontWordSpacingFactor(fontNumber));
    
    eLineDistance->setFloat(  eTextHeight->getFloat() *
                              fonts->getFontLineDistanceFactor(fontNumber));
  }
}



// Clear text:
//
void
RFontDialog::clearText() 
{
  meText->clear();
}




// Load a text:
//
void
RFontDialog::loadText() 
{
  meText->loadFile();
}



// Save a text:
//
void
RFontDialog::saveText() 
{
  meText->saveFile();
}



// Cut selected text:
//
void
RFontDialog::cutText() 
{
  meText->cut();
}



// Copy selected text:
//
void
RFontDialog::copyText() 
{
  meText->copyText();
}



// Paste text into textfield:
//
void
RFontDialog::pasteText() 
{
  meText->paste();
}



// Resize Event:
//
void
RFontDialog::resizeEvent(QResizeEvent *_ev)
{
  QDialog::resizeEvent(_ev);

  int buttonWidth = 80;          // Width of buttons at the bottom
  int buttonHeight= 22;          // Height of buttons at the bottom
  
  int border      = width()/61;  // Border between objects
  
  RLOG("\nresizeEvent");

  RCONFIG->addSetting("Application:FontDialogWindowWidth", width());
  RCONFIG->addSetting("Application:FontDialogWindowHeight", height());

  bOk->    setGeometry(width()-border-buttonWidth*2, height()-border-buttonHeight,
                       buttonWidth, buttonHeight);
  bCancel->setGeometry(width()-border-buttonWidth, height()-border-buttonHeight,
                       buttonWidth, buttonHeight);
  /*bHelp->  setGeometry(width()-border-buttonWidth, height()-border-buttonHeight,
                       buttonWidth, buttonHeight);*/
}



// Move event:
//
void 
RFontDialog::moveEvent(QMoveEvent* _ev)
{
  QDialog::moveEvent(_ev);
  
  RCONFIG->addSetting("Application:FontDialogWindowX", x());
  RCONFIG->addSetting("Application:FontDialogWindowY", y());
}



// EOF






