/***************************************************************************
                          rlog.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rlog.cpp 1998/08/27 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
**  Usage:
**  ~~~~~~
**  RLog* log = RLog::getRLog();
**    -> returns always the same log object
**  RLOG(value);
**  RLog::getRLog()->device()->flush();
**
*****************************************************************************/


#include "rlog.h"

#include <qfile.h>
#include <qdatetime.h>

#include "rprgdef.h"


RLog* RLog::theOneAndOnlyRLog=0;


// Get the one and only RLog-Object:
//   create a new one on first call
//
RLog* 
RLog::getRLog()
{
  if(theOneAndOnlyRLog==0) {
    theOneAndOnlyRLog = new RLog;
  }
  return theOneAndOnlyRLog;
}



// Constructor:
//
RLog::RLog()
{
#ifdef DEF_RDEBUG
  file = new QFile(DEF_DEBUGFILE);

  // Clear File:
  //
  file->open(IO_WriteOnly);
  file->close();

  // Open File in append mode:
  //
  file->open(IO_WriteOnly|IO_Append);
  setDevice(file);
#endif
}



// Destructor:
//
RLog::~RLog()
{
#ifdef DEF_RDEBUG
  file->close();
#endif
}



// Log string values:
//
void   
RLog::log(const char* _log)
{
#ifdef DEF_RDEBUG
  *this << _log;
  file->flush();
#endif
}



// Log int values:
//
void   
RLog::log(int _log)
{
#ifdef DEF_RDEBUG
  *this << _log;
  file->flush();
#endif
}



// Log float values:
//
void   
RLog::log(float _log)
{
#ifdef DEF_RDEBUG
  *this << _log;
  file->flush();
#endif
}



// Log char values:
//
void   
RLog::log(char _log)
{
#ifdef DEF_RDEBUG
  *this << _log;
  file->flush();
#endif
}



// Log bool values:
//
#ifndef DEF_SOLARIS
void   
RLog::log(bool _log)
{
#ifdef DEF_RDEBUG
  if(_log) *this << "true";
  else     *this << "false";
  file->flush();
#endif
}
#endif



// Log current Time:
//
void   
RLog::logTime()
{
#ifdef DEF_RDEBUGTIME
  QTime t = QTime::currentTime();
  char buf[128];
  sprintf(buf, "%03d", t.msec());
  *this << "\n" << t.toString() << "." << buf;
  file->flush();
#endif
}


// EOF3

