/***************************************************************************
                          rpreferencesdialog.cpp  -  description
                             -------------------
    begin                : Tue Nov 23 1999
    copyright            : (C) 1999 by Andrew Mustun
    email                : andrew@qcad.org
 ***************************************************************************/

#include "rpreferencesdialog.h"

#include <qlayout.h>
#include <qmessagebox.h>

#include "rappwin.h"
#include "rcombobox.h"
#include "rconfig.h"
#include "rlabel.h"
#include "rlineedit.h"
#include "rprgdef.h"
#include "rstatuspanel.h"


/*! \class RPreferencesDialog
    \author Andrew Mustun
    \brief Provides the preferences dialog called from "Options" -> "Preferences" menu.
*/

/*! Constructor
*/
RPreferencesDialog::RPreferencesDialog(QWidget * parent, const char * name, bool modal, WFlags f)
  : QTabDialog(parent,name,modal,f)
{
  setFixedSize(350, 194);

  setCaption( DEF_APPNAME );

  QGridLayout *gl;

  // Language Tab:
  //
  QWidget *wLanguage = new QWidget( this, "wLanguage" );
  gl = new QGridLayout( wLanguage, 5, 2, 1 );
  gl->setRowStretch(0, 3);
  gl->setRowStretch(1, 6);
  gl->setRowStretch(2, 6);
  gl->setRowStretch(3, 6);
  gl->setRowStretch(4, 3);

    // Language:
    //
    RLabel *lLanguage = new RLabel( RMES(484), wLanguage );
    gl->addWidget( lLanguage, 1, 0, AlignRight );
    cbLanguage = new RComboBox( wLanguage, "cbLanguage" );
    for(int i=0; i<RCONFIG->getLanguageNum(); ++i) {
      cbLanguage->insertItem( RCONFIG->getLanguage(i) );
    }
    cbLanguage->setEditText( RCONFIG->getLanguageName( RCONFIG->getSetting("Language:Language") ) );
    gl->addWidget( cbLanguage, 1, 1, AlignLeft );

  addTab( wLanguage, RMES(483) );


  // Layout:
  //
  QWidget *wLayout = new QWidget( this, "wLayout" );
  gl = new QGridLayout( wLayout, 5, 2, 1 );
  gl->setRowStretch(0, 3);
  gl->setRowStretch(1, 6);
  gl->setRowStretch(2, 6);
  gl->setRowStretch(3, 6);
  gl->setRowStretch(4, 3);

    // Font size for GUI elements:
    //
    RLabel *lFontSize0 = new RLabel( RMES(485), wLayout );
    gl->addWidget( lFontSize0, 1, 0, AlignRight );

    cbFontSize0 = new RComboBox( true, wLayout, "cbLayout" );
    cbFontSize0->insertItem( "8" );
    cbFontSize0->insertItem( "10" );
    cbFontSize0->insertItem( "12" );
    cbFontSize0->setEditText( RCONFIG->getSetting("Application:FontSize0") );
    gl->addWidget( cbFontSize0, 1, 1, AlignLeft );

    // Font size for Grid width:
    //
    RLabel *lFontSize1 = new RLabel( RMES(486), wLayout );
    gl->addWidget( lFontSize1, 2, 0, AlignRight );

    cbFontSize1 = new RComboBox( true, wLayout, "cbLayout" );
    cbFontSize1->insertItem( "8" );
    cbFontSize1->insertItem( "10" );
    cbFontSize1->insertItem( "12" );
    cbFontSize1->setEditText( RCONFIG->getSetting("Application:FontSize1") );
    gl->addWidget( cbFontSize1, 2, 1, AlignLeft );

    // Font size for Status panel:
    //
    RLabel *lFontSize2 = new RLabel( RMES(487), wLayout );
    gl->addWidget( lFontSize2, 3, 0, AlignRight );

    cbFontSize2 = new RComboBox( true, wLayout, "cbLayout" );
    cbFontSize2->insertItem( "8" );
    cbFontSize2->insertItem( "10" );
    cbFontSize2->insertItem( "12" );
    cbFontSize2->setEditText( RCONFIG->getSetting("Application:FontSize2") );
    gl->addWidget( cbFontSize2, 3, 1, AlignLeft );

  addTab( wLayout, RMES(488) );


  // Paths Tab:
  //
  QWidget *wPaths = new QWidget( this, "wPaths" );
  gl = new QGridLayout( wPaths, 5, 2, 1 );
  gl->setRowStretch(0, 3);
  gl->setRowStretch(1, 6);
  gl->setRowStretch(2, 6);
  gl->setRowStretch(3, 6);
  gl->setRowStretch(4, 3);

    // Browser Path:
    //
    RLabel *lBrowser = new RLabel( RMES(489), wPaths );
    gl->addWidget( lBrowser, 1, 0, AlignRight );
    eBrowserPath = new RLineEdit( wPaths, "eBrowserPath" );

    eBrowserPath->setText( RCONFIG->getSetting( "Paths:BrowserPath") );
    gl->addWidget( eBrowserPath, 1, 1, AlignLeft );

  addTab( wPaths, RMES(490) );

  setOkButton( RMES(46) );
  setCancelButton( RMES(47) );
}


/*! Destructor
*/
RPreferencesDialog::~RPreferencesDialog()
{
}



/*! Slot accept.
*/
void
RPreferencesDialog::accept()
{
  // Language:
  //
  RCONFIG->addSetting( "Language:Language",
                       RCONFIG->getLanguageSign(cbLanguage->currentText()) );

  // Layout:
  //
  RCONFIG->addSetting( "Application:FontSize0",
                       cbFontSize0->currentText() );
  RCONFIG->addSetting( "Application:FontSize1",
                       cbFontSize1->currentText() );
  RCONFIG->addSetting( "Application:FontSize2",
                       cbFontSize2->currentText() );

  // Paths:
  //
  RCONFIG->addSetting( "Paths:BrowserPath",
                       eBrowserPath->text() );

  // Please restart...:
  //
  QMessageBox::information( this, DEF_APPNAME, RMES(491), RMES(46) );

  RAppWin::getRAppWin()->getStatusPanel()->reinit();

  QTabDialog::accept();
}



// EOF














