
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

#include <X11/Intrinsic.h>

#include "config.h"

#include "pcd.h"
#include "xpcd.h"
#include "toolbox.h"
#include "shmalloc.h"

void
loadimage(Widget shell, struct PCD_IMAGE *img,
	  int x1, int x2, int y1, int y2, int size,
	  char *command, char *filename)
{
    int             left, top, width, height, y, sock, pid;
    struct sockaddr_un server_addr;
    unsigned char  *buf;
    FILE           *fp;
    int             x11_sock = ConnectionNumber(dpy);

    int             fd[2] =
    {0, 0};
    unsigned char  *shm_addr = NULL;

    left = (x1 << size) >> 2;
    top = (y1 << size) >> 2;
    width = ((x2 - x1) << size) >> 2;
    height = ((y2 - y1) << size) >> 2;
    if (-1 == pcd_select(img, size, 0, load_grays, 0, pcd_get_rot(img, 0),
			 &left, &top, &width, &height)) {
	tell_user(shell, "str_perror_title", pcd_errmsg);
	goto oom;
    }
    if (command == VIEWER_INTERN) {
	if (-1 == pipe(fd)) {
	    xperror(shell, "pipe");
	    goto oom;
	}
	shm_addr = sh_malloc(width * height * (load_grays ? 1 : 3));
	if (NULL == shm_addr) {
	    xperror(shell, sh_failed_syscall);
	    goto oom;
	}
    }
    switch (pid = fork()) {
    case 0:
	close(x11_sock);
	if (command != VIEWER_INTERN && command != VIEWER_GIMP)
	    setpgid(0, 0);
	break;
    case -1:
	xperror(shell, "fork");
	goto oom;
    default:
	pcd_free(img);
	if (command == VIEWER_INTERN) {
	    close(fd[1]);
	    new_viewer(fd[0], shm_addr, pid, filename, width, height);
	}
	return;
    }

    if (command == VIEWER_INTERN) {
	close(fd[0]);
	if (-1 == pcd_decode(img)) {
	    fprintf(stderr, "%s:%d: libpcd: %s\n",
		    __FILE__, __LINE__, pcd_errmsg);
	    exit(1);
	}
	for (y = 0; y < height; y++) {
	    if (-1 == pcd_get_image_line
		(img, y, shm_addr + (load_grays ? 1 : 3) * width * y,
		 load_grays ? PCD_TYPE_GRAY : PCD_TYPE_RGB, 0)) {
		fprintf(stderr, "%s:%d: libpcd: %s\n",
			__FILE__, __LINE__, pcd_errmsg);
		exit(1);
	    }
	}
	pcd_close(img);
	close(fd[1]);
	exit(0);
    }
    if (command == VIEWER_GIMP) {
	server_addr.sun_family = AF_UNIX;
	strcpy(server_addr.sun_path, gimp_sock);

	if (-1 == (sock = socket(PF_UNIX, SOCK_STREAM, 0))) {
	    PERROR("socket");
	    exit(1);
	}
	if (-1 == connect(sock, (struct sockaddr *) &server_addr,
			  sizeof(server_addr))) {
	    PERROR("connect");
	    exit(1);
	}
	if (NULL == (fp = fdopen(sock, "w"))) {
	    PERROR("fdopen");
	    exit(1);
	}
    } else {
	if (NULL == (fp = popen(command, "w"))) {
	    PERROR("popen");
	    exit(1);
	}
    }

    fprintf(fp, "P%c\n%i %i\n255\n", load_grays ? '5' : '6', width, height);
    fflush(fp);
    if (-1 == pcd_decode(img)) {
	fprintf(stderr, "%s:%d: libpcd: %s\n",
		__FILE__, __LINE__, pcd_errmsg);
	exit(1);
    }
    buf = malloc(width * 3);
    for (y = 0; y < height; y++) {
	if (-1 == pcd_get_image_line(img, y, buf,
			 load_grays ? PCD_TYPE_GRAY : PCD_TYPE_RGB, 0)) {
	    fprintf(stderr, "%s:%d: libpcd: %s\n",
		    __FILE__, __LINE__, pcd_errmsg);
	    exit(1);
	}
	if (width != fwrite(buf, load_grays ? 1 : 3, width, fp)) {
	    PERROR("fwrite");
	    exit(1);
	}
    }

    if (command == VIEWER_GIMP)
	fclose(fp);
    else
	pclose(fp);

    pcd_close(img);
    exit(0);

  oom:
    if (fd[0])
	close(fd[0]);
    if (fd[1])
	close(fd[1]);
    pcd_free(img);
    return;
}
