/* Zgv v3.1 - GIF, JPEG and PBM/PGM/PPM viewer, for VGA PCs running Linux.
 * Copyright (C) 1993-1998 Russell Marks. See README for license details.
 *
 * munglogo.c - generates zgvlogo.h from zgvlogo.mrf
 */

#include <stdio.h>
#include <stdlib.h>
#include "zgv.h"
#include "readmrf.h"

int logow,logoh;

unsigned char *readzgvlogo(void);
void writezgvlogo(unsigned char *image);



int main()
{
unsigned char *image;

printf("Making logo file from `zgvlogo.mrf'...\n");
image=readzgvlogo();
if(image==NULL)
  printf("Couldn't find `zgvlogo.mrf'.\n"),exit(1);

writezgvlogo(image);
free(image);
exit(0);
}


unsigned char *readzgvlogo()
{
unsigned char *image,*pal;
int junk;
PICINFO gi;

if(read_mrf_file("zgvlogo.mrf",NULL,&image,&pal,&junk,&gi)!=_PIC_OK)
  return(NULL);
free(pal);
logow=gi.width; logoh=gi.height;
return(image);
}


void writezgvlogo(unsigned char *image)
{
FILE *out;
int x,y,c=0;
unsigned char *ptr;

if((out=fopen("zgvlogo.h","w"))==NULL)
  printf("Couldn't open `zgvlogo.h'.\n");
else
  {
  fprintf(out,
    "/* Zgv logo bitmap - automatically generated from zgvlogo.mrf,\n"
    " * edits will be lost! Use your own mrf in place of zgvlogo.mrf\n"
    " * if you want, it should be 620x80. Then run `munglogo'\n"
    " * on it to generate this file.\n"
    " * Or, er... you *could* just type `make'. :-)\n"
    " */\n\n"
    "int logoh=%d,logow=%d;\n"
    "unsigned char zgvlogo[]={\n",logoh,logow);
  for(y=0;y<logoh;y++)
    {
    ptr=image+y*logow;
    for(x=0;x<logow;x++,ptr++)
      {
      if((x%8)==0) c=0;
      c+=((*ptr)&1);
      if((x%8)==7)
        fprintf(out,"%3d,",c);
      else
        c<<=1;
      if((x%160)==159) fputc('\n',out);
      }
    if((x%8)>0)
      {
      if((x%8)!=7) c<<=(7-(x%8));
      fprintf(out,"%3d,",c);
      }
    fputc('\n',out);
    }
  fprintf(out,"\n  0};\n");
  fclose(out);
  printf("Logo file made ok.\n");
  }
}
