/*
 * dgserver.h
 *
 * definitions required for the server daemon.
 */

#define TRUE	1
#define	FALSE	0

/* The default UDP port to use */
#define	IPPORT_REMOTE	1234

/* The default network device we will configure encap routes on to */
#define	DEFDEV		"tunl0"

/* The default retransmission timer for route broadcasts (in seconds) */
#define	DEFTIMER	300

/* The interval at which we timeout our routes */
#define	CLOCK_TICK	1

/* The maximum length of request message we will accept */
#define	MAXRQLEN	512

/* The maximum length of the route we will accept */
#define	MAXNETLEN	255

/* The maximum length of the route we will accept */
#define	MAXKEYLEN	20

/* NOS 'remote' commands relating to IPIP dynamic route */
#define	ROUTE_ME	4
#define	UNROUTE_ME	5

/* The default initialisation file to use */
#define	CONFFILE		"/etc/dgserver.conf"
#define	BUFLEN		80

/* Prototypes */
int main(int argc, char ** argv);
int parseconf(char *conffile);
int cidrtoin(char *netmask, struct in_addr *netmaska);
void flushhostrts(void);
void timeoutrt(void);
void addhostrt(struct in_addr *network, struct in_addr *netmask, char *key);
int refreshrt(struct in_addr *network, struct in_addr *netmask, struct in_addr *gateway, char *key);


