// areafile.h
//
// Copyright (C) 1999  Robert Barron, KA5WSS
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef _AREAFILE_H_
#define _AREAFILE_H_

#include "rfile.h"

//#define MAX_AREA_COUNT    200

class RAreaFile : public RFile {
    
//    typedef struct ctyinfostruct {
//        char *countryName;
//        char *countryPrefix;
//        int zone;
//    } ctyinfo;
public:
    // This struct must be public so that Watcom does not
    //  complain about the self referencial structure.
    typedef struct areainfostruct {
        char *smallArea;
        char *bigArea;
        int callDistrict;
        struct areainfostruct *next;
    } areaInfo;
private:
//    ctyinfo ctyList[MAX_CTY_COUNT];
    int areaCount;

    areaInfo *areaList;
    
    boolean ProcessAreaFile();
    boolean AddAreaToList(char *, char *);
//    boolean AddCallToList(char *, int);
public:

    RAreaFile()                   {areaCount = 0; areaList = NULL;};
    ~RAreaFile();
    RAreaFile(char *name);
#ifdef LINUX
    boolean open(char *name, int mode = ios::in);
#else
    boolean open(char *name, int mode = ios::in | ios::binary);
#endif
    
    boolean GetInfo(const char *, char *);
};

#endif
