/*
 * afaprs.c
 *
 * This module handles the channels designated for aprs.
 *
 * $Id: afaprs.c,v 1.11 1996/08/31 05:02:44 ron Exp $
 *
 *
 */
#include <unistd.h>
#include <stdio.h>
#include "afos.h"

int aprs_chan_init ( AF_CHANNEL *chan, void (*read_callback)() ) ;
int aprs_write ( AF_CHANNEL *chan, unsigned char *dat, int count ) ;
static void thru_echo_handler ( void *private, int event );

AF_CHANNEL_LINK *aprs_list ;
static ECHO_CHANNEL *aprs_fd_table[AF_MAX_FILES];

afaprs_init()
{
	int i;

	for  ( i = 0 ; i < AF_MAX_FILES ; i++ )
		aprs_fd_table[i] = NULL ;
}

/*
	parse_aprs parses out the 'aprs' line in the config file
*/
int
parse_aprs( char *line )
{
	static char args[4][80] ;
	AF_CHANNEL *chan ;
	AF_CHANNEL_LINK *link ;
	APRS_STRUCT *mystuff ;
	int count ;

	count = sscanf ( line,  "%[^ 	\n]%*[ 	,]"
							"%[^, 	\n]%*[ 	,]"
							"%[^, 	\n]%*[ 	,]"
							"%[^, 	\n]%*[ 	,]",
		args[0], args[1], args[2], args[3] ) ;

	if ( count != 4 )
	{
		fprintf ( stderr, "\r\nAFOSD: Unable to parse the following line:\n%s\n"
			"Insufficient parameters for afos-in designation\n"
			"Usage:\n"
"aprs-thru <CHANNEL NAME> <APRS COMPUTER CHANNEL NAME> <APRS TNC CHANNEL NAME>"
"\n", line);
		exit (-1);
	}
	if (!verify_unique_portname(args[1]))
	{
		fprintf(stderr,"\r\nERROR in port configuration file\n%s\n"
					   "aprs-thru channel name '%s' is already in use\n",
						args[1]) ;
		exit (-1);
	}

	chan = (AF_CHANNEL *)malloc( sizeof(*chan) ) ;
	if (!chan)
	{
		fprintf(stderr, "Unable to allocate new channel definition space\n");
		exit (-1);
	}
	
	/* Put new channel on the channel list */
	chan->next = channel_list ;
	channel_list = chan ;
	strncpy ( chan->name, args[1], AFCHAN_NAME_SIZE ) ;

	/* Put new channel on the aprs_list */
	link = (AF_CHANNEL_LINK *)malloc(sizeof(AF_CHANNEL_LINK));
	if (!link)
	{
		fprintf(stderr, "Unable to allocate new channel definition space\n");
		exit (-1);
	}
	link->next = aprs_list ;
	aprs_list = link ;
	link->channel = chan ;

	/* Allocate our private data structure and fill it out with our
	   configuration info */
	mystuff = (APRS_STRUCT *)malloc( sizeof(*mystuff) ) ;
	if (!mystuff)
	{
		fprintf(stderr, "Unable to allocate new channel definition space\n");
		exit (-1);
	}
	strncpy ( mystuff->pc_name, args[2], AFCHAN_NAME_SIZE ) ;
	strncpy ( mystuff->tnc_name, args[3], AFCHAN_NAME_SIZE ) ;

	chan->private = mystuff ;

	/* Fill out the rest of the channel info */
	chan->fd = -1 ;
	chan->init = aprs_chan_init ;
	chan->chanwrite = aprs_write ;
#if 1
	printf("config line: '%s'\n"
			"args[0]: '%s'\n"
			"args[1]: '%s'\n"
			"args[2]: '%s'\n"
			"args[3]: '%s'\n",
			line, args[0], args[1], args[2], args[3] );
#endif
#if 1
	printf( "config line: '%s'\n"
			"channel name: '%s'\n"
			"pc name: '%s'\n"
			"tnc name: '%s'\n",
			line, chan->name, mystuff->pc_name, mystuff->tnc_name ) ;
#endif
}


/*
	file_init initializes a file channel
*/
int
aprs_chan_init ( AF_CHANNEL *chan, void (*read_callback)() )
{
	APRS_STRUCT *mystuff = chan->private ;
	AF_CHANNEL *p ;

#if 0
	fprintf(stderr, "aprs_chan_init: initializing '%s'\n",chan->name);
#endif
	/* 
		Verify channels are defined, set-up select entry, etc.
	*/
	if (verify_unique_portname(mystuff->pc_name))
	{
		fprintf(stderr,"\r\nERROR in port configuration file\n"
					   "aprs-thru pc channel  '%s' is un-defined\n",
						mystuff->pc_name) ;
		exit (-1);
	}
	if (verify_unique_portname(mystuff->tnc_name))
	{
		fprintf(stderr,"\r\nERROR in port configuration file\n"
					   "aprs-thru tnc channel '%s' is un-defined\n",
						mystuff->tnc_name) ;
		exit (-1);
	}

	for ( p = channel_list ; 
		 (p && (!mystuff->aprs_tnc || !mystuff->aprs_pc)) ; p = p->next )
	{
		if ( strcmp ( p->name, mystuff->pc_name) == 0 )
			mystuff->aprs_pc = p ;
		if ( strcmp ( p->name, mystuff->tnc_name) == 0 )
			mystuff->aprs_tnc = p ;
	}

	if (!mystuff->aprs_tnc)
	{
		fprintf( stderr,
		"\r\nAFOSD internal error: Unable to find tnc channel '%s'\n",
			mystuff->tnc_name ) ;
		exit (-1);
	}

	if (!mystuff->aprs_pc)
	{
		fprintf( stderr,
		"\r\nAFOSD internal error: Unable to find pc channel '%s'\n",
			mystuff->pc_name ) ;
		exit (-1);
	}

	/* Allocate space for the two echo_structures */
	mystuff->from_tnc = (ECHO_CHANNEL *)malloc( sizeof(ECHO_CHANNEL) ) ;
	mystuff->from_pc = (ECHO_CHANNEL *)malloc( sizeof(ECHO_CHANNEL) ) ;
	if ( (!mystuff->from_tnc) || (!mystuff->from_pc) )
	{
		fprintf(stderr, "Unable to allocate new channel definition space\n");
		exit (-1);
	}
	mystuff->from_tnc->from = mystuff->aprs_tnc ;
	mystuff->from_tnc->to = mystuff->aprs_pc ;
	mystuff->from_tnc->from_tally = &mystuff->from_tnc_echo_count ;
	mystuff->from_pc->from = mystuff->aprs_pc ;
	mystuff->from_pc->to = mystuff->aprs_tnc ;
	mystuff->from_pc->from_tally = &mystuff->from_pc_echo_count ;

	mystuff->aprs_tnc->init ( mystuff->aprs_tnc, thru_echo_handler ) ;
#if 0
	fprintf (stderr, "thru-echo: installing channel '%s' fd=%d\n",
		mystuff->aprs_tnc->name,  mystuff->aprs_tnc->fd );
#endif
	if ( aprs_fd_table[mystuff->aprs_tnc->fd] == NULL )
		aprs_fd_table[mystuff->aprs_tnc->fd] = mystuff->from_tnc ;
	else {
		fprintf (stderr, "thru-echo: re-installation of channel '%s'\n",
			mystuff->aprs_tnc->name );
		return ;
	}

	mystuff->aprs_pc->init ( mystuff->aprs_pc, thru_echo_handler ) ;
#if 0
	fprintf (stderr, "thru-echo: installing channel '%s' fd=%d\n",
		mystuff->aprs_pc->name, mystuff->aprs_pc->fd );
#endif
	if ( aprs_fd_table[mystuff->aprs_pc->fd] == NULL )
		aprs_fd_table[mystuff->aprs_pc->fd] = mystuff->from_pc ;
	else {
		fprintf (stderr, "thru-echo: re-installation of channel '%s'\n",
			mystuff->aprs_pc->name );
		return ;
	}

	/*
		zero counters
	*/
	mystuff->aprs_out_count = 0 ;
	mystuff->from_tnc_echo_count = 0 ;
	mystuff->from_pc_echo_count = 0 ;
}

static void
thru_echo_handler ( void *private, int data )
{
	int  ret ;
	AF_CHANNEL *chan = private ;
	ECHO_CHANNEL *e ;

	if ( (e = aprs_fd_table[chan->fd]) == NULL )
		fprintf( stderr, "thru-echo: received data on unreferenced channel\n");

	if ( data < 0 )
		return  ;

	data &= 0xff ;
	(*e->from_tally)++ ;
	e->to->chanwrite ( e->to, &data, 1 ) ;
}

/*
	APRS is defined as a channel.  Writes to the APRS channel go to both
	the local PC and the TNC
*/
int aprs_write ( AF_CHANNEL *chan, unsigned char *dat, int count ) 
{
	APRS_STRUCT *mystuff = chan->private ;

	mystuff->aprs_tnc->chanwrite ( mystuff->aprs_tnc, dat, count );
	mystuff->aprs_pc->chanwrite ( mystuff->aprs_pc, dat, count );
	mystuff->aprs_out_count += count ;
	chan->write_count++ ;
	chan->bytes_written += count ;
}
