/*
 * afosconfig.c
 *
 * This module reads the config files and initializes data structures
 * accordingly
 *
 * $Id: afconfig.c,v 1.5 1996/08/27 23:10:06 ron Exp $
 *
 */
#include <unistd.h>
#include <stdio.h>
#include "afos.h"

AF_CHANNEL *channel_list ;
char afos_in_channel_name[AFCHAN_NAME_SIZE];
AF_CHANNEL *afos_in_channel ;

static FILE *portfp, *routefp ;

static char line[256] ;
static char args[8][80] ;

typedef struct _PORT_TOKENS_ {
	char *name ;
	int (*process_line)() ;
	} PORT_TOKENS ;

int parse_port ( ) ;
int parse_file ( ) ;
int parse_log ( ) ;
int parse_tcp ( ) ;
int parse_process ( ) ;
int parse_pipe ( ) ;
int parse_afosin ( ) ;
int parse_aprs ( ) ;

PORT_TOKENS port_array[] = {
	{ "port", parse_port  },
	{ "file", parse_file },
	{ "log", parse_log },
	{ "tcp", parse_tcp },
	{ "process", parse_process },
	{ "pipe", parse_pipe },
	{ "afos-in", parse_afosin },
	{ "aprs-thru", parse_aprs } } ;

extern char *Channel_description[] ;

#define PORT_TOKEN_NUM 8

void
afconfig_init()
{
	afos_in_channel = NULL ;
	channel_list = NULL ;
	aprs_list = NULL ;
}

/*
	find_port_token looks to see if the string 'name' matches any tokens in
					the token array.
	returns         A pointer to the appropriate token handling structure
		  OR
					NULL if there is no match
*/
static PORT_TOKENS *
find_port_token ( char *name )
{
	PORT_TOKENS *p = port_array ;
	int count ;

	for ( count = 0 ; (count < PORT_TOKEN_NUM) ; count++ )
	{ 
		if (strcmp ( name, p[count].name) == 0 )
			return &p[count] ;
	}
	
	/* If we complete the loops and get here, we failed to find the token */
	return NULL ;
}

void
afconfigports( char *filename )
{
	int count ;
	PORT_TOKENS *token_handler;

	portfp = fopen ( filename, "r" ) ;
	if ( portfp == NULL )
	{
		fprintf(stderr, "Unable to open port configuration file '%s'\n",
			filename );
		exit ( -1 ) ;
	}

	while ( fgets (line, 256, portfp) )
	{
		/* THIS SHOULD BE A SMALLER SCAN TO SIMPLY LOOK FOR THE FIRST TOKEN */
		count = sscanf ( line, "%[^ 	\n]%*[ 	,]"
							   	"%[^ 	\n]%*[ 	,]"
							   	"%[^ 	\n]%*[ 	,]"
							   	"%[^ 	\n]%*[ 	,]"
							   	"%[^ 	\n]%*[ 	,]"
							   	"%[^ 	\n]%*[ 	,]"
							   	"%[^ 	\n]%*[ 	,]"
							   	"%[^ 	\n]%*[ 	,]",
			args[0], args[1], args[2], args[3], 
			args[4], args[5], args[6], args[7]) ;

		if (count > 0)
		{
			if ( args[0][0] == '#' )
				continue ;

			token_handler = find_port_token ( args[0] ) ;
			if (token_handler)
				token_handler->process_line(line);
			else
				fprintf(stderr, "AFOSD Warning! The line:\n%s\n"
								"has been ignored.\n", line ) ;
		}
	}
}

int
verify_unique_portname( char *name )
{
	AF_CHANNEL * p ;

	for ( p = channel_list ; p ; p = p->next )
	{
		if (strcmp(name,p->name) == 0 )
			return 0 ;
	}
	return 1 ;
}

void
afconfig_port_init()
{
	AF_CHANNEL *p ;

	/* 
		Call all of the channels' init routines.  Pass them a NULL for
		the read_callback function pointer.  This tells them to assume
		that they will be used as write-only channels.
	*/
	for ( p = channel_list ; p ; p = p->next )
		p->init( p, NULL ) ;
}

void
afconfig_list_channels()
{
	AF_CHANNEL *p ;

	printf("Channel list: ");
	for ( p = channel_list ; p ; p = p->next )
		printf("%s->", p->name );
	printf("<END>\n");
}
