/*
 * affile.c
 *
 * This module supports ordinary file channel
 *
 * $Id: affile.c,v 1.6 1996/08/27 23:10:07 ron Exp $
 *
 */
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include "afos.h"

int file_init ( AF_CHANNEL *chan , void (*read_callback)() ) ;
int file_write ( AF_CHANNEL *chan, unsigned char *dat, int size ) ;
int file_getchar ( AF_CHANNEL *chan ) ;

typedef struct _FILE_STRUCT_ {
	char file_name[AFCHAN_NAME_SIZE];
	} FILE_STRUCT ;

/*
	parse_file parse out the 'file' line in the config file
*/
int
parse_file( char *line )
{
	static char args[8][80] ;
	AF_CHANNEL *chan ;
	FILE_STRUCT *mystuff ;
	int count ;

	count = sscanf ( line,  "%[^ 	\n]%*[ 	,]"
							"%[^, 	\n]%*[ 	,]"
							"%[^, 	\n]%*[ 	,]",
		args[0], args[1], args[2] ) ;

	if ( count < 3 )
	{
		fprintf ( stderr, "\r\nAFOSD: Unable to parse the following line:\n%s\n"
			"Insufficient parameters for file definition\n"
			"Usage:\n"
	"file <CHANNEL NAME> <FILE NAME> \n", line);
		exit (-1);
	}

	if (!verify_unique_portname( args[1] ) )
	{
		fprintf(stderr,"\r\nERROR in port configuration file on LINE:\n%s\n"
					   "Port '%s' already defined\n",
						line, args[1] ) ;
		exit (-1);
	}

	chan = (AF_CHANNEL *)malloc( sizeof(*chan) ) ;
	if (!chan)
	{
		fprintf(stderr, "Unable to allocate new channel definition space\n");
		exit (-1);
	}
	
	/* Put new channel on the channel list */
	chan->next = channel_list ;
	channel_list = chan ;
	strncpy ( chan->name, args[1], AFCHAN_NAME_SIZE ) ;

	/* Allocate our private data structure and fill it out with our
	   configuration info */
	mystuff = (FILE_STRUCT *)malloc( sizeof(*mystuff) ) ;
	if (!mystuff)
	{
		fprintf(stderr, "Unable to allocate new channel definition space\n");
		exit (-1);
	}
	strncpy ( mystuff->file_name, args[2], AFCHAN_NAME_SIZE ) ;

	chan->private = mystuff ;

	/* Fill out the rest of the channel info */
	chan->fd = -1 ;
	chan->init = file_init ;
	chan->chanwrite = file_write ;
	chan->changetchar = file_getchar ;
#if 0
	printf( "config line: '%s'\n"
			"channel name: '%s'\n"
			"file name: '%s'\n",
			line, chan->name, mystuff->file_name ) ;
#endif
}


/*
	file_init initializes a file channel
*/
int
file_init ( AF_CHANNEL *chan, void (*read_callback)() )
{
}

/*
	file_write writes a message out to the file channel
*/
int
file_write ( AF_CHANNEL *chan, unsigned char *dat, int size )
{
	int ret ;
	FILE_STRUCT *mystuff = chan->private ;

	/* Check to see if previously initialized */
	if ( chan->fd != -1 )
	{
		/* Already initialized, just return */
		return 0 ;
	}

	/* 
		open the file for creation, over-write
	*/
	chan->fd = open ( mystuff->file_name, O_CREAT|O_WRONLY|O_TRUNC, 0664 ) ;
	if (chan->fd < 0)
	{
		fprintf(stderr, "AFOSD: Unable to open file '%s' for channel '%s'\n",
			mystuff->file_name, chan->name ) ;
		return -1 ;
	}

	chan->write_count++ ;
	chan->bytes_written += size ;
	ret = write ( chan->fd, dat, size ) ;

	close ( chan->fd ) ;
	chan->fd = -1 ;

	return size ;
}

/*
	file_getchar doesn't make sense for a file that's truncated
	non-blocking and may return a negative value if an error occurs
*/
int
file_getchar ( AF_CHANNEL *chan )
{
#if 1
	return -1 ;
#else
	int i, result;
	FILE_STRUCT *mystuff = chan->private ;

	if ( chan->fd < 0 )
	{
		/* 
			Open the file for reading.  getchar is only used when a 'file'
			channel is used as the afos-in channel.  A file input is used
			when testing configurations
		*/
		chan->fd = open ( mystuff->file_name, O_RDONLY ) ;
		if (chan->fd < 0 )
		{
			fprintf(stderr, 
				"AFOSD: unable to read from file '%s' for channel '%s'\n",
				mystuff->file_name, chan->name ) ;
			exit (-1);
		}
	}

	result = read ( chan->fd, &i, 1 ) ;

	if ( result <= 0 )
		return -1 ;

	chan->bytes_read++ ;
	return i ;
#endif
}
