/* Copyright (C) 1994 Guido Vattrodt DL3BZN
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

/* misc.c	miscellaneous
 */

#include <sys/types.h>
#include <stdio.h>      /* must be before pwd.h */
#include <pwd.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <unistd.h>
#include <setjmp.h>

#include <Xm/Xm.h>		
#include <Xm/Text.h>		
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/MessageB.h>

#include "buildsaddr.h"
#include "xconvers.h" 	
#include "text.h"
#include "misc.h"

/* globals */
extern int 	socket_fd;		/* socket filedescriptor */
extern FILE	*log_stream;		/* steam for recording file */
static jmp_buf	sjbuf;			/* for timeout */

/* static (local) prototypes */
static void timeout(void);


/*---------------------------------------------------------------------------
 * errormsg + EXIT 
 */

void stop(char *arg)
{
  if (*arg) perror(arg);
  if(socket_fd > 2) close(socket_fd);
  if(log_stream != NULL) fclose(log_stream);
  exit(0);
}

/*---------------------------------------------------------------------------
 * ExitCB  beendet Programm
 */
void ExitCB(widget, client_data, call_data)
	Widget	widget;
	caddr_t	client_data, call_data;
{
  stop("");
}


/*---------------------------------------------------------------------------
 * timeout  connect-timeout Routine
 */
static void timeout(void)
{
  longjmp(sjbuf, 1);
}


/*---------------------------------------------------------------------------
 * ConnectCB  connect the convers-Server
 */
void ConnectCB(widget, client_data, call_data)
	Widget	widget;
	caddr_t	client_data, call_data;
{
  AppWidgets *app_w = (AppWidgets*) client_data;

  struct sockaddr 	*addr;
  int 			addrlen;
  char 			buffer[2048];
  int			result;

  /* -- get address --- */
  sprintf(buffer,"%s:%s",  app_w->set->server,  app_w->set->port);
  if(!(addr = build_sockaddr(buffer, &addrlen)))  {
	InfoMsg("Wrong server address or port!", app_w);
	return;
  }

  /* -- open socket -- */
  if ((socket_fd = socket(addr->sa_family, SOCK_STREAM, 0)) < 3 ) {
	InfoMsg("Error opening the socket!", app_w);
	close(socket_fd);
	socket_fd = 0;
	return;
  }

  sprintf(buffer, "*** connecting %s:%s ...\n", app_w->set->server,  app_w->set->port);
  insert(buffer, app_w);
  handle_XtEvents();
  alarm(TIMEOUT);
  signal(SIGALRM, (void (*)())timeout);
  if(!setjmp(sjbuf)) {
  	result = connect(socket_fd, addr, addrlen);
	signal(SIGALRM, SIG_IGN);
  	if(result) {
	  InfoMsg("connection refused!", app_w);
	  close(socket_fd);
	  socket_fd = 0;
	  return;
	}
  } else {
	  InfoMsg("connection timeout!", app_w);
	  close(socket_fd);
	  socket_fd = 0;
	  return;
  }

  sprintf(buffer, "/NAME %s %s %s\n", app_w->set->name, app_w->set->channel, app_w->set->pnote);
  if (write(socket_fd, buffer, strlen(buffer)) < 0) stop("write to socket");

  /* connect Button inaktiv, disconnect aktiv */
  XtSetSensitive(app_w->button_connect, False);  
  XtSetSensitive(app_w->button_disconnect, True);  
  XtSetSensitive(app_w->menu_comm, True);  
}

/*---------------------------------------------------------------------------
 * DisconnectCB  disconnected convers-Server
 */
void DisconnectCB(widget, client_data, call_data)
	Widget	widget;
	caddr_t	client_data, call_data;
{
  AppWidgets *app_w = (AppWidgets*) client_data;

  char 			buffer[2048];

  if(socket_fd) {
     close(socket_fd);
     socket_fd = 0;
     sprintf(buffer, "\n*** server %s disconnected\n",app_w->set->server);
     insert(buffer, app_w);				/* in Text einfuegen */

     /* connect Button aktiv, disconnect Button inaktiv  */
     XtSetSensitive(app_w->button_connect, True);  
     XtSetSensitive(app_w->button_disconnect, False);  
     XtSetSensitive(app_w->menu_comm, False);  
  }
}


/*---------------------------------------------------------------------------
 *   InfoMsg	zeigt Infomessage in Box an
 */
void InfoMsg(message, app_w)
	char		*message;
 	AppWidgets	*app_w;
{
  Widget	button, box;
  XmString	string;
  Arg		arg[3];
  Cardinal	n;

  string = XmStringCreate(message, XmSTRING_DEFAULT_CHARSET);

  n = 0;
  XtSetArg(arg[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
  XtSetArg(arg[n], XmNmessageString, string); n++;
  XtSetArg(arg[n], XmNdialogTitle, XmStringCreate("info", XmSTRING_DEFAULT_CHARSET)); n++;
  box = XmCreateInformationDialog(app_w->form, "infoBox", arg, n);
  button = XmMessageBoxGetChild(box, XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(button); 
  button = XmMessageBoxGetChild(box, XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(button); 
  
  XtManageChild(box);
  XtFree(string);
}

/*---------------------------------------------------------------------------
 *   ConnectingMsg	zeigt Infomessage in Box an
 */
void ConnectingMsg(message, app_w)
	char		*message;
 	AppWidgets	*app_w;
{
  Widget	button, box;
  XmString	string;
  Arg		arg[3];
  Cardinal	n;

  string = XmStringCreate(message, XmSTRING_DEFAULT_CHARSET);

  n = 0;
  XtSetArg(arg[n], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); n++;
  XtSetArg(arg[n], XmNmessageString, string); n++;
  XtSetArg(arg[n], XmNdialogTitle, XmStringCreate("wait", XmSTRING_DEFAULT_CHARSET)); n++;
  box = XmCreateWorkingDialog(app_w->form, "waitMessage", arg, n);

  button = XmMessageBoxGetChild(box, XmDIALOG_OK_BUTTON);
  XtUnmanageChild(button); 

  button = XmMessageBoxGetChild(box, XmDIALOG_SEPARATOR);
  XtUnmanageChild(button); 

  button = XmMessageBoxGetChild(box, XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(button); 
  button = XmMessageBoxGetChild(box, XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(button); 
  
  XtManageChild(box);
  app_w->wait_dialog = box;  
  XtFree(string);
}

/*---------------------------------------------------------------------------
 *   ResourceText  fetch one string from resource database
 */
char *ResourceText(widget, resource_name, default_value)
	Widget	widget;
	char	*resource_name;
	char	*default_value;
{
  char		*string;
  XtResource	resource_description[1];

  string = default_value;
  if(resource_name) {
     /* set description */
     resource_description[0].resource_name = resource_name;
     resource_description[0].resource_class = XmCString;
     resource_description[0].resource_type = XmRString;
     resource_description[0].resource_size = sizeof(char*);
     resource_description[0].resource_offset = 0;
     resource_description[0].default_type = XmRString;
     resource_description[0].default_addr = default_value;
     XtGetApplicationResources(widget, &string, resource_description, 1, NULL, 0);
  }
  return(string);
} 
 

