#include "global.h"

/*
 * Window
 */
static VALUE
gwin_initialize(self, type)
    VALUE self, type;
{
    set_widget(self, gtk_window_new(NUM2INT(type)));
    return Qnil;
}

static VALUE
gwin_set_policy(self, shrink, grow, auto_shrink)
    VALUE self, shrink, grow, auto_shrink;
{
    gtk_window_set_policy(GTK_WINDOW(get_widget(self)),
			  RTEST(shrink), RTEST(grow), RTEST(auto_shrink));
    return self;
}

static VALUE
gwin_set_title(self, title)
    VALUE self, title;
{
    gtk_window_set_title(GTK_WINDOW(get_widget(self)), STR2CSTR(title));
    return self;
}

static VALUE
gwin_set_position(self, pos)
    VALUE self, pos;
{
    gtk_window_position(GTK_WINDOW(get_widget(self)),
			(GtkWindowPosition)NUM2INT(pos));

    return self;
}

static VALUE
gwin_set_wmclass(self, wmclass1, wmclass2)
    VALUE self, wmclass1, wmclass2;
{
    gtk_window_set_wmclass(GTK_WINDOW(get_widget(self)),
			   NIL_P(wmclass1)?NULL:STR2CSTR(wmclass1),
			   NIL_P(wmclass2)?NULL:STR2CSTR(wmclass2));
    return self;
}

static VALUE
gwin_set_focus(self, win)
    VALUE self, win;
{
    gtk_window_set_focus(GTK_WINDOW(get_widget(self)), get_widget(win));
    return self;
}

static VALUE
gwin_set_default_size(self, w, h)
    VALUE self, w, h;
{
    gtk_window_set_default_size(GTK_WINDOW(get_widget(self)),
				NUM2INT(w), NUM2INT(h));
    return self;
}

static VALUE
gwin_set_default(self, win)
    VALUE self, win;
{
    gtk_window_set_default(GTK_WINDOW(get_widget(self)), get_widget(win));
    return self;
}
/* 1.2.x
static VALUE
gwin_add_accel(self, accel)
    VALUE self, accel;
{
    gtk_window_add_accelerator_table(GTK_WINDOW(get_widget(self)),
				     get_gtkacceltbl(accel));
    return self;
}

static VALUE
gwin_rm_accel(self, accel)
    VALUE self, accel;
{
    gtk_window_remove_accelerator_table(GTK_WINDOW(get_widget(self)),
					get_gtkacceltbl(accel));
    return self;
}
*/
static VALUE
gwin_grab_add(self)
    VALUE self;
{
    gtk_grab_add(get_widget(self));
    return self;
}

static VALUE
gwin_grab_remove(self)
    VALUE self;
{
    gtk_grab_remove(get_widget(self));
    return self;
}


static VALUE
gwin_set_modal(self, modal)
    VALUE self, modal;
{
    gtk_window_set_modal(GTK_WINDOW(get_widget(self)), RTEST(modal));
    return self;
}

void Init_gtk_window()
{
    gWindow = rb_define_class_under(mGtk, "Window", gBin);

    rb_define_const(gWindow, "SIGNAL_MOVE_RESIZE", rb_str_new2("move_resize"));
    rb_define_const(gWindow, "SIGNAL_SET_FOCUS", rb_str_new2("set_focus"));

    rb_define_method(gWindow, "initialize", gwin_initialize, 1);
    rb_define_method(gWindow, "set_title", gwin_set_title, 1);
    rb_define_method(gWindow, "set_policy", gwin_set_policy, 3);
    rb_define_method(gWindow, "set_wmclass", gwin_set_wmclass, 2);
    rb_define_method(gWindow, "set_focus", gwin_set_focus, 1);
    rb_define_method(gWindow, "set_default_size", gwin_set_default_size, 2);
    rb_define_method(gWindow, "set_default", gwin_set_default, 1);
    /* 1.2.x
       rb_define_method(gWindow, "add_accelerator_table", gwin_add_accel, 1);
       rb_define_method(gWindow, "remove_accelerator_table", gwin_rm_accel, 1);
    */
    rb_define_method(gWindow, "position", gwin_set_position, 1);
    rb_define_method(gWindow, "set_position", gwin_set_position, 1);
    rb_define_method(gWindow, "grab_add", gwin_grab_add, 0);
    rb_define_method(gWindow, "grab_remove", gwin_grab_remove, 0);
    rb_define_method(gWindow, "set_modal", gwin_set_modal, 1);
}


/*
 * Dialog
 */
static VALUE
dialog_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_dialog_new());
    return Qnil;
}

static VALUE
dialog_vbox(self)
    VALUE self;
{
    GtkWidget *dialog = get_widget(self);
    return make_gobject(gVBox, GTK_OBJECT(GTK_DIALOG(dialog)->vbox));
}

static VALUE
dialog_action_area(self)
    VALUE self;
{
    GtkWidget *dialog = get_widget(self);
    return make_gobject(gHBox, GTK_OBJECT(GTK_DIALOG(dialog)->action_area));
}

void Init_gtk_dialog()
{
    gDialog = rb_define_class_under(mGtk, "Dialog", gWindow);

    /* rb_define_const(gDialog, "SIGNAL_", rb_str_new2("")); */

    rb_define_method(gDialog, "initialize", dialog_initialize, 0);
    rb_define_method(gDialog, "vbox", dialog_vbox, 0);
    rb_define_method(gDialog, "action_area", dialog_action_area, 0);
}


/*
 * FileSelction
 */
static VALUE
fsel_initialize(self, title)
    VALUE self, title;
{
    set_widget(self, gtk_file_selection_new(STR2CSTR(title)));
    return Qnil;
}

static VALUE
fsel_set_fname(self, fname)
    VALUE self, fname;
{
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(get_widget(self)),
				    STR2CSTR(fname));

    return self;
}

static VALUE
fsel_get_fname(self)
    VALUE self;
{
    gchar *fname;

    fname = gtk_file_selection_get_filename(GTK_FILE_SELECTION(get_widget(self)));

    return rb_str_new2(fname);
}

static VALUE
fsel_ok_button(self)
    VALUE self;
{
    VALUE b = rb_iv_get(self, "ok_button");

    if (NIL_P(b)) {
	GtkWidget *w = GTK_FILE_SELECTION(get_widget(self))->ok_button;
	b = make_widget(gButton, w);
	rb_iv_set(self, "ok_button", b);
    }

    return b;
}

static VALUE
fsel_cancel_button(self)
    VALUE self;
{
    VALUE b = rb_iv_get(self, "cancel_button");

    if (NIL_P(b)) {
	GtkWidget *w = GTK_FILE_SELECTION(get_widget(self))->cancel_button;
	b = make_widget(gButton, w);
	rb_iv_set(self, "cancel_button", b);
    }

    return b;
}

static VALUE
fsel_help_button(self)
    VALUE self;
{
    VALUE b = rb_iv_get(self, "help_button");

    if (NIL_P(b)) {
	GtkWidget *w = GTK_FILE_SELECTION(get_widget(self))->help_button;
	b = make_widget(gButton, w);
	rb_iv_set(self, "help_button", b);
    }

    return b;
}

static VALUE
fsel_action_area(self)
    VALUE self;
{
    VALUE area = rb_iv_get(self, "action_area");

    if (NIL_P(area)) {
	GtkWidget *w = GTK_FILE_SELECTION(get_widget(self))->action_area;
	area = make_widget(gHBox, w);
	rb_iv_set(self, "action_area", area);
    }

    return area;
}

static VALUE
fsel_show_fileop_buttons(self)
    VALUE self;
{
    gtk_file_selection_show_fileop_buttons(GTK_FILE_SELECTION(get_widget(self)));
    return self;
}

static VALUE
fsel_hide_fileop_buttons(self)
    VALUE self;
{
    gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(get_widget(self)));
    return self;
}

void Init_gtk_fileselection()
{
    gFileSel = rb_define_class_under(mGtk, "FileSelection", gWindow);

    rb_define_method(gFileSel, "initialize", fsel_initialize, 1);
    rb_define_method(gFileSel, "set_filename", fsel_set_fname, 1);
    rb_define_method(gFileSel, "get_filename", fsel_get_fname, 0);
    rb_define_method(gFileSel, "ok_button", fsel_ok_button, 0);
    rb_define_method(gFileSel, "cancel_button", fsel_cancel_button, 0);
    rb_define_method(gFileSel, "help_button", fsel_help_button, 0);
    rb_define_method(gFileSel, "action_area", fsel_action_area, 0);
    rb_define_method(gFileSel, "show_fileop_buttons", fsel_show_fileop_buttons, 0);
    rb_define_method(gFileSel, "hide_fileop_buttons", fsel_hide_fileop_buttons, 0);
}

/*
 * ColorSelectionDialog
 */
static VALUE
cdialog_initialize(self, title)
    VALUE self;
{
    set_widget(self, gtk_color_selection_dialog_new(STR2CSTR(title)));
    return Qnil;
}

static VALUE
cdialog_get_colorsel(self)
    VALUE self;
{
    VALUE sel = rb_iv_get(self, "colorsel");

    if (NIL_P(sel)) {
	GtkWidget *w = GTK_COLOR_SELECTION_DIALOG(get_widget(self))->colorsel;
	sel = make_widget(gColorSel, w);
	rb_iv_set(self, "colorsel", sel);
    }

    return sel;
}

static VALUE
cdialog_get_ok_button(self)
    VALUE self;
{
    VALUE b = rb_iv_get(self, "ok_button");

    if (NIL_P(b)) {
	GtkWidget *w = GTK_COLOR_SELECTION_DIALOG(get_widget(self))->ok_button;
	b = make_widget(gButton, w);
	rb_iv_set(self, "ok_button", b);
    }

    return b;
}

static VALUE
cdialog_get_cancel_button(self)
    VALUE self;
{
    VALUE b = rb_iv_get(self, "cancel_button");

    if (NIL_P(b)) {
	GtkWidget *w
	    = GTK_COLOR_SELECTION_DIALOG(get_widget(self))->cancel_button;
	b = make_widget(gButton, w);
	rb_iv_set(self, "cancel_button", b);
    }

    return b;
}

static VALUE
cdialog_get_help_button(self)
    VALUE self;
{
    VALUE b = rb_iv_get(self, "help_button");

    if (NIL_P(b)) {
	GtkWidget *w
	    = GTK_COLOR_SELECTION_DIALOG(get_widget(self))->help_button;
	b = make_widget(gButton, w);
	rb_iv_set(self, "help_button", b);
    }

    return b;
}

void Init_gtk_color_selection_dialog()
{
    gColorSelDialog = rb_define_class_under(mGtk, "ColorSelectionDialog", gWindow);

    rb_define_method(gColorSelDialog, "initialize", cdialog_initialize, 1);
    rb_define_method(gColorSelDialog, "colorsel", cdialog_get_colorsel, 0);
    rb_define_method(gColorSelDialog, "ok_button", cdialog_get_ok_button, 0);
    rb_define_method(gColorSelDialog, "cancel_button", cdialog_get_cancel_button, 0);
    rb_define_method(gColorSelDialog, "help_button", cdialog_get_help_button, 0);
}

/*
 * InputDialog
 */
static VALUE
idiag_initialize(self)
    VALUE self;
{
    set_widget(self, gtk_input_dialog_new());
    return Qnil;
}

void Init_gtk_input_dialog()
{
    gInputDialog = rb_define_class_under(mGtk, "InputDialog", gDialog);

    rb_define_const(gInputDialog, "SIGNAL_ENABLE_DEVICE", rb_str_new2("enable_device"));
    rb_define_const(gInputDialog, "SIGNAL_DISABLE_DEVICE", rb_str_new2("disable_device"));

    rb_define_method(gInputDialog, "initialize", idiag_initialize, 0);
}
