#
# WATCOM/options.mk -	Part of Makefile for PFE, compiler options
#			for WATCOM-C on OS/2, DOS or Windows/NT.
#
# - please set the variable TARGET according to the system you want
#   to build for.
#
# - the Makefile works with dmake in OS/2
#   (dmake - Copyright (c) 1990,1991 by Dennis Vadura, Version 3.80, PL 0),
#   and the way I configured it (default) dmake uses COMSPEC as command line
#   interpreter which in my case (default) is CMD.EXE.
#   If you use gnu-make and/or a unix-like shell as command line interpreter,
#   be prepared to get errors. One possible cause is the neccessary quoting
#   of a possible `\' in $(PREFIX). I must leave it up to you to get it right.
#
# - when you build under DOS, be warned that the command line for the
#   final link step is too long. In target pfe$e replace $(OBJECTS) by *.OBJ.
#

# Targets -- I tried these:

#TARGET	= OS2V2		# 32 bit OS/2 text mode executable
			# Can anybody tell me how to get a descent behaviour
			# from Ctl-C or Ctl-Break?

#TARGET	= DOS4G		# 32 bit DOS executable, uses Rational 4GW extender

#TARGET = WIN386	# 32 bit Windows executable
			#   to use this define /bt=WINDOWS and /l=WIN386
			#   link like this:
			#     $(CL) $(LDFLAGS) /fe=pfe $(OBJECTS) ...
			#     wbind pfe -n -s d:\watcom\binw\win386.ext
			# i.e. allow wcl to build a pfe.rex and bind this
			# with the Watcom windows extender giving pfe.exe.
			# It compiles and runs but not reasonable.
			# This is just a feasibility study yet.

# I didn't try these but expect them to work:
#TARGET	= ERGO		# 32 bit Ergo DOS extender executables
#TARGET	= PHARLAP	# 32 bit Pharlap DOS extender executables

# These will probably need some changes in term-wat.c:
#TARGET = NT		# 32 bit NT character mode executable
#TARGET = QNX386	# 32 bit QNX executable

# There are more possible targets mentioned in the Watcom manual but
# I haven't heard of them before so I can't tell anything about them.

# Where you store online help files and other stuff.
PREFIX	= "C:"		# define a C-string, path delimiter \\ inside ""
PFELIB	= "C:\\lib\\pfe"
PFEHLP	= "C:\\lib\\pfe\\help"


SYSTEM	= WATCOM
CC	= wcc386
CL	= wcl386
CPP	= wcl386 /p
LD	= $(CL)

# /bt=	target OS for wcc386
# /w4	highest possible warning level
# /zq	supress signon messages
# /zc	place const objects and strings in the code segment
# /d	define target as preprocessor symbol
OPTIONS	= /bt=$(TARGET) /w4 /zq /zc /dWC_$(TARGET)

# Recommended in the Watcom manual for best speed:
# /omaxnet
# /5r	optimize for Pentium and use registers for parameter passing
# /zp4	align data on 4 byte boundaries
OPTIM	= /omaxnet /5r /zp4

DEBUG	= /d2

# /l=	target OS for wcl386
# /x	make names case sensitive (maybe useless, seems not to hurt)
LFLAGS	= /l=$(TARGET) /x

STRIP	= 

LIBS	= 

TERM_O	= term-wat$o
SYS_O	= unix$o


