/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1995  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.14 of 01-November-95
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	sunsite.unc.edu:/pub/languages/forth/pfe-VERSION.tar.gz
 * or	ftp.cygnus.com:/pub/forth/pfe-VERSION.tar.gz
 *
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * nonansi.h --	Include file, gathers non-ANSI includes for low level
 *		file I/O and operating system access in general.
 *
 * (duz 28Feb95)
 */

#ifndef __NONANSI_H
#define __NONANSI_H

#if defined HAVE_SYS_IOCTL_H
# include <sys/ioctl.h>	/* structs and constants for low level tty access */
#endif

#if defined HAVE_FCNTL_H
# include <fcntl.h>	/* structs and constants for low level file access */
#endif

#if defined HAVE_SYS_STAT_H
# include <sys/stat.h>	/* structs and constants for stat() and fstat() */
#endif

#if defined HAVE_DIRECT_H
# include <direct.h>	/* directory related */
#endif

#if defined HAVE_SYS_NDIR_H
# include <sys/ndir.h>	/* ??? */
#endif

#if defined HAVE_UTIME_H
# include <utime.h>	/* file access/modification time structure */
#endif

#if defined HAVE_SYS_TIME_H
# include <sys/time.h>
#endif

#if defined HAVE_SYS_UTIME_H
# include <sys/utime.h>
#endif

#if defined HAVE_POLL_H
# include <poll.h>	/* the poll() system call */
#elif defined HAVE_SYS_POLL_H
# include <sys/poll.h>
#endif

#if defined HAVE_SYS_SELECT_H
# include <sys/select.h> /* the select() system call */
#endif

#if defined HAVE_PROCESS_H
# include <process.h>	/* fork, exec */
#elif defined HAVE_SYS_PROCESS_H
# include <sys/process.h>
#endif

#if defined HAVE_UNISTD_H
# include <unistd.h>	/* most low level file functions on Posix systems */
#endif

#if defined HAVE_IO_H
# include <io.h>	/* equivalent to unistd.h on some DOS like systems */
#endif

#if defined HAVE_LIBC_H	/* NeXT has this */
# include <libc.h>
#endif

#if defined HAVE_CONIO_H
# include <conio.h>	/* DOS like systems define cputs() here */
#endif

#if defined HAVE_DOS_H
# include <dos.h>	/* DOS like systems define things like delay() here */
#endif

#if defined HAVE_MEM_H
# include <mem.h>	/* some systems have memcpy() here */
#endif

#if defined HAVE_MEMORY_H
# include <memory.h>	/* or here */
#endif

#if defined HAVE_STRINGS_H
# include <strings.h>	/* place where old BSD systems keep bcopy() */
#endif

#endif /* ndef __NONANSI_H */
