#include "r.h"
// Connect r objects to Python

PyObject* 
r_new (PyObject* self, PyObject* args) {
    try {
        Tuple rargs(args);
        if (rargs.length() < 2 || rargs.length() > 3) {
            throw RuntimeError("Incorrect # of args to r(start,stop [,step]).");
        }
        Int start(rargs[0]);
        Int stop(rargs[1]);
        Int step(1);
        if (rargs.length() == 3) {
            step = rargs[2];
        } 
        if (long(start) > long(stop) + 1 || long(step) == 0) {
            throw RuntimeError("Bad arguments to r(start,stop [,step]).");
        }
        return new r(start, stop, step);
    }
    catch(const Exception&) {
        return Null ();
    }   
}

static PyObject *
r_repr(PyObject* arg)
{
    r* robj = static_cast<r*>( arg);
	return new_reference_to(String(robj->asString()));
}

static int
r_length(PyObject* arg)
{
    r* robj = static_cast<r*>( arg);
    return robj->length();
}

static PyObject*
r_item(PyObject* arg, int i) 
{
    r* robj = static_cast<r*>( arg);
    return new_reference_to(Int(robj->item(i)));
}

static PyObject*
r_concat(PyObject* arg, PyObject *j) {
    r* robj = static_cast<r*>( arg);
    Int k(j);
    return robj->extend(int(k));
}

static PyObject*
r_slice(PyObject* arg, int i, int j) {
    r* robj = static_cast<r*>( arg);
    return robj->slice(i,j);
}


static PyObject *
r_getattr(PyObject* arg, char *name)
{
    r* robj = static_cast<r*>( arg);
    if(STD::string(name) == "c") return new_reference_to(Float(300.0));
    if(STD::string(name) == "start") return new_reference_to(Int(robj->start));
    return robj->getattr(name);
}

// "regular" methods...
static PyObject *
r_amethod(PyObject* self, PyObject* args)
{
    Tuple t(args);
    t.verify_length(1);
    R r1(self);
    List result;
    result.append(r1);
    result.append(t[0]);
    return new_reference_to(result);
}

static PyObject*
r_value (PyObject* self, PyObject* args)
{
    Tuple t(args);
    R r1(self);
    return new_reference_to(r1.value(t));
}

static PyObject*
r_assign(PyObject* self, PyObject* args) 
{
    Tuple t(args);
    t.verify_length(2);
    R r1(self);
    Tuple t1(t[0]); // subscripts
    Object o2(t[1]); // rhs;
    r1.assign (t1, o2);
    return Nothing();
}

void init_rtype () {
        r::behaviors().name("r");
        r::behaviors().doc("r objects: start, stop, step");
        r::behaviors().repr(r_repr);
        r::behaviors().getattr(r_getattr);
        r::behaviors().sequence_length(r_length);
        r::behaviors().sequence_item(r_item);
        r::behaviors().sequence_slice(r_slice);
        r::behaviors().sequence_concat(r_concat);
        r::methods().add("amethod", r_amethod);
        r::methods().add("assign", r_assign);
        r::methods().add("value", r_value);
}

