/********************************************************************************
*                                                                               *
*                         D o c u m e n t   O b j e c t                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXDocument.h,v 1.1 1999/09/14 13:32:47 jeroen Exp $                      *
********************************************************************************/
#ifndef FXDOCUMENT_H
#define FXDOCUMENT_H


// Forward
class FXWindow;


// FXDocuments class
class FXAPI FXDocument : public FXObject {
  FXDECLARE(FXDocument)
private:
  FXString     title;             // Title to appear above windows
  FXString     filename;          // File name to save to
  FXbool       modified;          // Document has been modified
public:
  long onUpdTitle(FXObject*,FXSelector,void*);
  long onUpdFilename(FXObject*,FXSelector,void*);
public:
  enum{
    ID_TITLE=10000,                 // Don't interfere with viewer's message id's
    ID_FILENAME,
    ID_LAST                
    };
public:
  FXDocument();
  FXbool isModified() const { return modified; }
  void setModified(FXbool mdfy=TRUE){ modified=mdfy; }
  void setTitle(const FXString& name);
  FXString getTitle() const { return title; }
  void setFilename(const FXString& path);
  FXString getFilename() const { return filename; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXDocument();
  };

#endif

