/********************************************************************************
*                                                                               *
*                            L a b e l   W i d g e t                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXLabel.h,v 1.2 1999/09/20 22:12:56 jeroen Exp $                        *
********************************************************************************/
#ifndef FXLABEL_H
#define FXLABEL_H


// Justification modes
enum FXJustifyStyle {
  JUSTIFY_NORMAL       = 0,
  JUSTIFY_CENTER_X     = 0,
  JUSTIFY_LEFT         = 0x00008000,
  JUSTIFY_RIGHT        = 0x00010000,
  JUSTIFY_HZ_APART     = JUSTIFY_LEFT|JUSTIFY_RIGHT,
  JUSTIFY_CENTER_Y     = 0,
  JUSTIFY_TOP          = 0x00020000,
  JUSTIFY_BOTTOM       = 0x00040000,
  JUSTIFY_VT_APART     = JUSTIFY_TOP|JUSTIFY_BOTTOM
  };



// Relationship options for icon-labels
enum FXIconPosition {
  ICON_UNDER_TEXT      = 0,
  ICON_AFTER_TEXT      = 0x00080000,
  ICON_BEFORE_TEXT     = 0x00100000,
  ICON_ABOVE_TEXT      = 0x00200000,
  ICON_BELOW_TEXT      = 0x00400000,
  TEXT_OVER_ICON       = ICON_UNDER_TEXT,
  TEXT_AFTER_ICON      = ICON_BEFORE_TEXT,
  TEXT_BEFORE_ICON     = ICON_AFTER_TEXT,
  TEXT_ABOVE_ICON      = ICON_BELOW_TEXT,
  TEXT_BELOW_ICON      = ICON_ABOVE_TEXT
  };

  
// Label
class FXAPI FXLabel : public FXFrame {
  FXDECLARE(FXLabel)
protected:
  FXString label; 
  FXIcon*  icon;
  FXFont*  font;
  FXHotKey hotkey;
  FXint    hotoff;
  FXColor  textColor;
protected:
  FXLabel();
  FXint labelHeight(const FXString& text) const;
  FXint labelWidth(const FXString& text) const;
  void drawLabel(FXDCWindow& dc,const FXString& text,FXint hot,FXint tx,FXint ty,FXint tw,FXint th);
  void just_x(FXint& tx,FXint& ix,FXint tw,FXint iw);
  void just_y(FXint& ty,FXint& iy,FXint th,FXint ih);
private:
  FXLabel(const FXLabel&);
  FXLabel &operator=(const FXLabel&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onHotKeyPress(FXObject*,FXSelector,void*);
  long onHotKeyRelease(FXObject*,FXSelector,void*);
  long onCmdGetStringValue(FXObject*,FXSelector,void*);
  long onCmdSetStringValue(FXObject*,FXSelector,void*);
public:
  FXLabel(FXComposite* p,const FXString& text,FXIcon* ic=0,FXuint opts=(JUSTIFY_NORMAL|ICON_BEFORE_TEXT),FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);
  virtual void create();
  virtual void detach();
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  void setText(const FXString& text);
  FXString getText() const { return label; }
  void setIcon(FXIcon* ic);
  FXIcon* getIcon() const { return icon; }
  void setFont(FXFont *fnt);
  FXFont* getFont() const { return font; }
  FXColor getTextColor() const { return textColor; }
  void setTextColor(FXColor clr);
  void setJustify(FXuint mode);
  FXuint getJustify() const;
  void setIconPosition(FXuint mode);
  FXuint getIconPosition() const;
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXLabel();
  };



#endif
