/********************************************************************************
*                                                                               *
*                P a c k e r   C o n t a i n e r   W i d g e t                  *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXPacker.h,v 1.4 1999/11/09 23:58:37 jeroen Exp $                        *
********************************************************************************/
#ifndef FXPACKER_H
#define FXPACKER_H


// Default spacing
#define DEFAULT_SPACING        4

  

// Packs children in cavity
class FXAPI FXPacker : public FXComposite {
  FXDECLARE(FXPacker)
protected:
  FXColor baseColor;
  FXColor hiliteColor;
  FXColor shadowColor;
  FXColor borderColor;
  FXint   padtop;
  FXint   padbottom;
  FXint   padleft;
  FXint   padright;
  FXint   hspacing;
  FXint   vspacing;
  FXint   border;
protected:
  FXPacker();
  void drawBorderRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawRaisedRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawSunkenRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawRidgeRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawGrooveRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawDoubleRaisedRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawDoubleSunkenRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawFocusRectangle(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  void drawFrame(FXDCWindow& dc,FXint x,FXint y,FXint w,FXint h);
  virtual void layout();
private:
  FXPacker(const FXPacker&);
  FXPacker &operator=(const FXPacker&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onFocusUp(FXObject*,FXSelector,void*);
  long onFocusDown(FXObject*,FXSelector,void*);
  long onFocusLeft(FXObject*,FXSelector,void*);
  long onFocusRight(FXObject*,FXSelector,void*);
public:
  FXPacker(FXComposite *p,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_SPACING,FXint pr=DEFAULT_SPACING,FXint pt=DEFAULT_SPACING,FXint pb=DEFAULT_SPACING,FXint hs=DEFAULT_SPACING,FXint vs=DEFAULT_SPACING);
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  void setFrameStyle(FXuint style);
  FXuint getFrameStyle() const;
  void setPackingHints(FXuint ph);
  FXuint getPackingHints() const;
  FXColor getHiliteColor() const { return hiliteColor; }
  FXColor getShadowColor() const { return shadowColor; }
  FXColor getBorderColor() const { return borderColor; }
  FXColor getBaseColor() const { return baseColor; }
  void setHiliteColor(FXColor clr);
  void setShadowColor(FXColor clr);
  void setBorderColor(FXColor clr);
  void setBaseColor(FXColor clr);
  FXint getPadTop() const { return padtop; }
  FXint getPadBottom() const { return padbottom; }
  FXint getPadLeft() const { return padleft; }
  FXint getPadRight() const { return padright; }
  void setPadTop(FXint pt);
  void setPadBottom(FXint pb);
  void setPadLeft(FXint pl);
  void setPadRight(FXint pr);
  FXint getHSpacing() const { return hspacing; }
  FXint getVSpacing() const { return vspacing; }
  void setHSpacing(FXint hs);
  void setVSpacing(FXint vs);
  FXint getBorderWidth() const { return border; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  };

  
#endif
