/********************************************************************************
*                                                                               *
*                        M e n u   P a n e   W i d g e t                        *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXMenuPane.cpp,v 1.1 1999/09/14 13:41:23 jeroen Exp $                    *
********************************************************************************/
#include "fxdefs.h"
#include "fxkeys.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXAccelTable.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDC.h"
#include "FXDCWindow.h"
#include "FXFont.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXGIFIcon.h"
#include "FXWindow.h"
#include "FXFrame.h"
#include "FXComposite.h"
#include "FXShell.h"
#include "FXPopup.h"
#include "FXMenuPane.h"


/*
  Notes:
  - Should FXPopup still exist?
*/


/*******************************************************************************/


// Object implementation
FXIMPLEMENT(FXMenuPane,FXPopup,NULL,0)



// Build empty one
FXMenuPane::FXMenuPane(FXWindow* owner,FXuint opts):
  FXPopup(owner,opts|FRAME_RAISED|FRAME_THICK){
  accelTable=new FXAccelTable;
  }


// Cursor is considered inside when it's in this window, or in any subwindow 
// that's open; we'll find the latter through the cascade menu, by asking it for 
// it's popup window.
FXbool FXMenuPane::contains(FXint parentx,FXint parenty) const {
  FXint x,y;
  if(FXPopup::contains(parentx,parenty)) return 1;
  if(getFocus()){
    getParent()->translateCoordinatesTo(x,y,this,parentx,parenty);
    if(getFocus()->contains(x,y)) return 1;
    }
  return 0;
  }

