/********************************************************************************
*                                                                               *
*                                 Test Table Widget                             *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* $Id: table.cpp,v 1.13 1999/10/14 05:55:07 jeroen Exp $                        *
********************************************************************************/
#include "fx.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>



 
/*******************************************************************************/


// Table Window
class TableWindow : public FXMainWindow {
  FXDECLARE(TableWindow)
protected:
    
  // Member data
  FXTooltip*         tooltip;
  FXMenuBar*         menubar;
  FXMenuPane*        filemenu;
  FXVerticalFrame*   contents;
  FXVerticalFrame*   frame;
  FXTable*           table;
  FXMenuPane*        tablemenu;
  FXMenuPane*        manipmenu;
  FXMenuPane*        selectmenu;
  
protected:
  TableWindow(){}

public:
  long onCmdTest(FXObject*,FXSelector,void*);
  long onCmdResizeTable(FXObject*,FXSelector,void*);

public:
  enum{
    ID_TEST=FXMainWindow::ID_LAST,
    ID_RESIZETABLE,
    ID_LAST
    };
    
public:
  TableWindow(FXApp* a);
  virtual void create();
  };


/*******************************************************************************/
  
// Map
FXDEFMAP(TableWindow) TableWindowMap[]={
  FXMAPFUNC(SEL_COMMAND,TableWindow::ID_TEST,TableWindow::onCmdTest),
  FXMAPFUNC(SEL_COMMAND,TableWindow::ID_RESIZETABLE,TableWindow::onCmdResizeTable),
  };


// Object implementation
FXIMPLEMENT(TableWindow,FXMainWindow,TableWindowMap,ARRAYNUMBER(TableWindowMap))


/*******************************************************************************/

  
// Make some windows
TableWindow::TableWindow(FXApp* a):FXMainWindow(a,"Table Widget Test",NULL,NULL,DECOR_ALL,0,0,0,0){
  static const FXchar *months[]={"January","February","March","April","May","June","July","August","September","October","November","December"};
  FXint r,c;
  
  // Tooltip
  tooltip=new FXTooltip(getApp());
  
  // Menubar
  menubar=new FXMenuBar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);
  
  // Separator
  new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|SEPARATOR_GROOVE);

  // Contents
  contents=new FXVerticalFrame(this,LAYOUT_SIDE_TOP|FRAME_NONE|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  
  frame=new FXVerticalFrame(contents,FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);
  
  // Table
  //table=new FXTable(frame,50,13,NULL,0,TABLE_HOR_GRIDLINES|TABLE_VER_GRIDLINES|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 2,2,2,2);
  table=new FXTable(frame,20,8,NULL,0,TABLE_HOR_GRIDLINES|TABLE_VER_GRIDLINES|LAYOUT_FILL_X|LAYOUT_FILL_Y,0,0,0,0, 2,2,2,2);
  table->setTableSize(50,14);
  table->setLeadingRows(3);
  table->setLeadingCols(3);
  table->setTrailingRows(3);
  table->setTrailingCols(3);
  
  // Initialize first/last fixed rows
  for(c=1; c<=12; c++){
    table->setItemText(0,c,months[c-1]);
    table->setItemText(49,c,months[c-1]);
    }
  
  // Initialize first/last fixed columns
  for(r=1; r<=48; r++){
    table->setItemText(r,0,FXStringVal(r));
    table->setItemText(r,13,FXStringVal(r));
    }
  
  // Initialize scrollable part of table
  for(r=1; r<=48; r++){
    for(c=1; c<=12; c++){
      table->setItemText(r,c,"r:"+FXStringVal(r)+" c:"+FXStringVal(c));
      }
    }
    
  // File Menu
  filemenu=new FXMenuPane(this);
  new FXMenuCommand(filemenu,"&Quit\tCtl-Q",NULL,getApp(),FXApp::ID_QUIT);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
  
  // Tab side
  tablemenu=new FXMenuPane(this);
  new FXMenuCommand(tablemenu,"Horizontal grid",NULL,table,FXTable::ID_HORZ_GRID);
  new FXMenuCommand(tablemenu,"Vertical grid",NULL,table,FXTable::ID_VERT_GRID);
  new FXMenuTitle(menubar,"&Options",NULL,tablemenu);
  
  manipmenu=new FXMenuPane(this);
  new FXMenuCommand(manipmenu,"Delete Column\tCtl-C",NULL,table,FXTable::ID_DELETE_COLUMN);
  new FXMenuCommand(manipmenu,"Delete Row\tCtl-R",NULL,table,FXTable::ID_DELETE_ROW);
  new FXMenuCommand(manipmenu,"Insert Column\tCtl-Shift-C",NULL,table,FXTable::ID_INSERT_COLUMN);
  new FXMenuCommand(manipmenu,"Insert Row\tCtl-Shift-R",NULL,table,FXTable::ID_INSERT_ROW);
  new FXMenuCommand(manipmenu,"Resize table...",NULL,this,TableWindow::ID_RESIZETABLE);
  new FXMenuTitle(menubar,"&Manipulations",NULL,manipmenu);
  
  selectmenu=new FXMenuPane(this);
  new FXMenuCommand(selectmenu,"Select All",NULL,table,FXTable::ID_SELECT_ALL);
  new FXMenuCommand(selectmenu,"Select Cell",NULL,table,FXTable::ID_SELECT_CELL);
  new FXMenuCommand(selectmenu,"Select Row",NULL,table,FXTable::ID_SELECT_ROW);
  new FXMenuCommand(selectmenu,"Select Column",NULL,table,FXTable::ID_SELECT_COLUMN);
  new FXMenuCommand(selectmenu,"Deselect All",NULL,table,FXTable::ID_DESELECT_ALL);
  new FXMenuTitle(menubar,"&Selection",NULL,selectmenu);
  }


// Test
long TableWindow::onCmdTest(FXObject*,FXSelector sel,void*){
  return 1;
  }


// Resize table
long TableWindow::onCmdResizeTable(FXObject*,FXSelector sel,void*){
  FXDialogBox dlg(this,"Resize Table");
  FXHorizontalFrame *frame=new FXHorizontalFrame(&dlg,LAYOUT_FILL_X|LAYOUT_FILL_Y);
  new FXLabel(frame,"Rows:",NULL,LAYOUT_SIDE_LEFT|LAYOUT_CENTER_Y);
  FXTextField* rows=new FXTextField(frame,5,NULL,0,JUSTIFY_RIGHT|FRAME_SUNKEN|FRAME_THICK|LAYOUT_SIDE_LEFT|LAYOUT_CENTER_Y);
  new FXLabel(frame,"Columns:",NULL,LAYOUT_SIDE_LEFT|LAYOUT_CENTER_Y);
  FXTextField* cols=new FXTextField(frame,5,NULL,0,JUSTIFY_RIGHT|FRAME_SUNKEN|FRAME_THICK|LAYOUT_SIDE_LEFT|LAYOUT_CENTER_Y);
  new FXButton(frame,"Cancel",NULL,&dlg,FXDialogBox::ID_CANCEL,FRAME_RAISED|FRAME_THICK|LAYOUT_SIDE_LEFT|LAYOUT_CENTER_Y);
  new FXButton(frame,"  OK  ",NULL,&dlg,FXDialogBox::ID_ACCEPT,FRAME_RAISED|FRAME_THICK|LAYOUT_SIDE_LEFT|LAYOUT_CENTER_Y);
  FXint oldnr,oldnc;
  oldnr=table->getNumRows();
  oldnc=table->getNumCols();
  rows->setText(FXStringVal(oldnr));
  cols->setText(FXStringVal(oldnc));
  if(dlg.execute()){
    FXint nr,nc,r,c;
    nr=FXIntVal(rows->getText());
    nc=FXIntVal(cols->getText());
    if(nr<0) nr=0;
    if(nc<0) nc=0;
    table->setTableSize(nr,nc);
    for(r=0; r<nr; r++){
      for(c=0; c<nc; c++){
        if(r>oldnr || c>oldnc){
          table->setItemText(r,c,"r:"+FXStringVal(r+1)+" c:"+FXStringVal(c+1));
          }
        }
      }
    }
  return 1;
  }


// Start
void TableWindow::create(){
  FXMainWindow::create();
  show();
  }


/*******************************************************************************/


// Start the whole thing
int main(int argc,char *argv[]){

  // Make application
  FXApp* application=new FXApp("TableApp","Test");
  
  // Open display
  application->init(argc,argv);
  
  // Make window
  new TableWindow(application);
  
  // Create app
  application->create();
  
  // Run
  application->run();
  }


