/*
 * This source code is part of my universal C library "libch".
 * Copyright (C) 1998,99 by Christian Hammers <ch@westend.com>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * History
 * 1999-10-16	Fixed possible buffer overflow.
 * 1998-06-25	Added ch_cgi_escape()
 * 1998-06-25	Fixed using ch_cgi_init() for starting via export QUERY_STRING
 * 1998-02-16	Extended ch_cgi_init() to use the program it as pipe.
 * 1998-02-02 	Renamed the project from libcgi to libch
 * 1998-02-01	added PID to cgi_debugfile name and remove it at cgi_done()
 * 1998-01-20	added cgi_malloc()	
 *
 *
 * Remember: /cgi-bin/test?aaa=1&bbb=2&ccc=3
 */

#ifdef HAVE_VSNPRINTF
# define __USE_GNU
#else
extern int vsnprintf(char* s, int n, char* fmt, ...);
#endif

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#include "libch.h"

typedef struct {
	char	*key;
	char	*value;
}		ch_cgi_struct;

char	       *ch_cgi_s;		/*internal: content string	   */
char	       *ch_cgi_s_cooked;	/*internal: content string with    */
					/*          \0s and url-unescaped  */
int		ch_cgi_num_elements;	/*internal: number of key elements */
int		ch_cgi_len;		/*internal: content-length         */
ch_cgi_struct  *ch_cgi_array;



/**     Exits program with given string and back button                 */
void ch_cgi_panic(char *format, ...) {
        va_list         ap;
        char            s[255];

	if (!ch_state_cgi_ctype) ch_cgi_content_type("text/html");

        va_start(ap,format);
	vsnprintf(s,sizeof(s)-1,format,ap); 
        va_end(ap);
	printf("<br>PANIC !<br>%s<br>",s);
	printf("<br><A HREF=\"%s\">back</A>",ch_getenv("HTTP_REFERER"));
        fflush(stdout);

        exit(EXIT_FAILURE);
}

/** 	Sets HTTP Content-Type						*/
void ch_cgi_content_type(char *content_type) {
	printf("Content-Type: %s\n\n",content_type);
	fflush(stdout);
}

/** Now make a copy of ch_cgi_s and store it into cg_cgi_s_cooked.	*/
/** In this copy every '=' and '&' (seperators) is replaced by NULL	*/
/** and the ch_cgi_s_array's pointers are set to the key and value	*/
/** strings. After that you can walk through the array and getting	*/
/** ch_cgi_s_array_pointer->key/value. (Unless key==NULL)		*/
void ch_cgi_init_cook() {
	char		*p;
	ch_cgi_struct	*array_p;

	/* make copy */
	ch_cgi_s_cooked = ch_malloc(strlen(ch_cgi_s)+1);
	strcpy(ch_cgi_s_cooked, ch_cgi_s);
	
	/* count elements and allocate memory */
	p=ch_cgi_s_cooked;       ch_cgi_num_elements=0;
	while (*p) if (*p++=='&') ch_cgi_num_elements++;
	                          ch_cgi_num_elements++;
	ch_cgi_array = ch_malloc(sizeof(ch_cgi_struct)*ch_cgi_num_elements);

        /* walk through the query_string and set the key/value pointers
         * at every occurance of '=' and '&' */
	array_p=ch_cgi_array;
	ch_cgi_array->key=ch_cgi_s_cooked;
	p=ch_cgi_s_cooked; 
	while (*p) {
		if (*p=='=') {
			array_p->value = p+1;
			ch_cgi_unescape(array_p->value);
			*p='\0';
		}
	        if (*p=='&') {
			if (array_p->value==NULL) /* last key */
				array_p->value=ch_empty_string;
	                array_p++;
	                array_p->key = p+1;
	                *p='\0';
	        }
	        p++;
	}
	/* I *hate* NULL values */
	if (array_p->value==NULL) array_p->value=ch_empty_string;
	/* terminating elemenent */
	array_p++;
	array_p->key=NULL; array_p->value=NULL;
}
 

/** 	Initialise the cgi routienes (gets the content string)		*/
/**	Try to get it non-cgi safe for debugging purposes.		*/
void ch_cgi_init() {
	string		s;
	
	/* print header if requested */
	if (!ch_state_cgi_ctype && ch_o_init_content_type) 
		ch_cgi_content_type("text/html");

	/*
	** get query string and store it in ch_cgi_s 
	*/ 
	if (!strcmp(ch_getenv("REQUEST_METHOD"),"POST")) {
		/* post */
		ch_cgi_len=atoi(ch_getenv("CONTENT_LENGTH"));
		if (ch_cgi_len==0) {
			ch_cgi_len=1;
		} else {
			ch_cgi_len+=2;
		}
		ch_cgi_s=ch_malloc(ch_cgi_len+1); 
		fgets(ch_cgi_s, ch_cgi_len, stdin);
	} else if (strlen(ch_getenv("QUERY_STRING"))>0) {
		/* get with input */
		ch_cgi_len=strlen(ch_getenv("QUERY_STRING"));
		ch_cgi_s=ch_malloc(ch_cgi_len);
		strcpy(ch_cgi_s, ch_getenv("QUERY_STRING"));
	} else if (strlen(ch_getenv("REQUEST_URI"))>0) {
		/* get without input */
		ch_cgi_len=1;
		ch_cgi_s=ch_malloc(ch_cgi_len);
		strcpy(ch_cgi_s, "");
	} else {
		/* stdin */
		printf("Input CGI parameter string !\n");
		fgets(s,sizeof(s),stdin);
		ch_cgi_len=strlen(s);
		ch_cgi_s=ch_malloc(ch_cgi_len+1);
		strncpy(ch_cgi_s, s, ch_cgi_len);
	}
	if (ch_cgi_s[strlen(ch_cgi_s)-1]=='\n') 
	    ch_cgi_s[strlen(ch_cgi_s)-1]='\0';

	ch_cgi_init_cook();
	/* alive or core dumped :-) */
}


/**	Includes a HTML file within the DOCUMENT_ROOT in CGI output	*/
void ch_cgi_include(const char *fname) {
	char		*s;
	string		buffer;
	int		i;
	FILE		*f;

	/* open file */
	s = ch_malloc(strlen(ch_getenv("DOCUMENT_ROOT"))+strlen(fname)+2);
	strncpy(s, ch_getenv("DOCUMENT_ROOT"), sizeof(s)-1);
	strncat(s, fname, sizeof(s)-strlen(s)-1);
	if (!(f=fopen(s,"r"))) {
		ch_cgi_panic("ch_cgi_include: cannot open %s (%d)", s, errno);
	}
	ch_free(s);

	/* pipe file content to stdout */
	while ((i=fread(buffer, 1, 1024, f))) {
		fwrite(buffer, 1, i, stdout);
	}

	fclose(f);
}	

/**	Dumps the ch_cgi_s string with all cgi values (DEBUG)		*/
void ch_cgi_dump() {
	string	s;

	sprintf(s,"<br>\nCH_CGI_DUMP=\"%s\"\n<br>\n",ch_cgi_s);
	___(s);
	printf("%s",s);
}

/**	Translates '+'  to ' ' and "%4D" to (char)0x4d			*/
char *ch_cgi_unescape(char *s) {
	int	i=0,ii=0;

	/* decode non-ascii chars */
	for (i=0,ii=0; s[ii]; i++,ii++) {
		if ((s[i]=s[ii])=='%') {
			s[i] = s[ii+1]>='A' ? s[ii+1]-'A'+10 : s[ii+1]-'0';
			s[i] *= 16;
			s[i] += s[ii+2]>='A' ? s[ii+2]-'A'+10 : s[ii+2]-'0';
			ii+=2;
		}
	}
	s[i]='\0';

	/* decode plus */
	for (i=0; s[i]; i++) if (s[i]=='+') s[i]=' ';	
	
	return s;
}


/** 	Returns the value of the key <name>.				*/
/**	If the name is non existent "" is returned.			*/
void ch_cgi_get_value(char *name, char *buffer, int bufsize) {
	ch_cgi_struct	*cgi_p;

	/* Nasty coderz out there ? */
	if ((buffer==NULL) || (bufsize<1)) {
		ch_panic("ch_cgi_get_value: %p,%d",buffer,bufsize);
	}

	/* Beware of the wulf. */
	if ((ch_cgi_s==NULL) || (ch_cgi_s[0]=='\0')) {
		strcpy(buffer,"");
		return;
	}
	
	cgi_p = ch_cgi_array;
	while (cgi_p->key) {
		if (!strcmp(cgi_p->key, name)) {
			if (strlen(cgi_p->value)+1 > bufsize) {
				ch_panic("ch_cgi_get_value: buffer too small");
			}
			strncpy(buffer, cgi_p->value, bufsize);
			ch_cgi_unescape(buffer);
			return;
		}
		cgi_p++;
	}
	strcpy(buffer,"");
}
	

/** 	Returns a pointer to the value of the key <name>.		*/
/**	If the name is non existent "" is returned.			*/
char *ch_cgi_value(char *name) {
	ch_cgi_struct	*cgi_p;

	cgi_p = ch_cgi_array;
	while (cgi_p->key) {
		if (!strcmp(cgi_p->key, name)) {
			return cgi_p->value;
		}
		cgi_p++;
	}
	return ch_empty_string;
}
	

/** 	Returns 0 if value is NOT set else 1				*/
int ch_cgi_isset_value(char *name) {
	string 	s;

	ch_cgi_get_value(name,s,sizeof(s));
	return ( strlen(s) ? 1 : 0 );
}

/**     Returns the CGI query string					*/
char *ch_cgi_get_string() {
	return ch_cgi_s;
}


/**     Sets the CGI query string					*/
void ch_cgi_set_string(char *query_string) {
	ch_free(ch_cgi_s);
	ch_cgi_s=ch_malloc(strlen(query_string)+1);
	strcpy(ch_cgi_s, query_string);
	ch_cgi_init_cook();
}
