/*
	test pattern generator
	**********************
	$Id: testpattern.c,v 1.2 1999/01/21 07:28:33 ajapted Exp $
	(c) H. Niemann  1997,1998

 *   This software is placed in the public domain and can be used freely
 *   for any purpose. It comes without any kind of warranty, either
 *   expressed or implied, including, but not limited to the implied
 *   warranties of merchantability or fitness for a particular purpose.
 *   Use it at your own risk. the author is not responsible for any damage
 *   or consequences raised by use or inability to use this program.
 
	This program creates a test pattern like ctmon3 and the
	Nokia montest program created or is/was broadcast on tv
	during program breaks, when there was no 24h program.

	for a first glance: run
		testpattern 
	or
		testpattern 3 600x300

	Very much is copied from ./demo.c
	The text output would require about 400x300 dots, but it works
	with less too.
*/
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>

#include <ggi/ggi.h>


ggi_visual_t vis;

ggi_uint white, black, red, green, blue, yellow, magenta, cyan;  

void usage(const char *prog)
{
	fprintf(stderr,"Usage:  %s [timeout [mode]]\n"
		"\ttimeout: wait <x> seconds;\n"
		"\t\t0: wait for keypress (default)\n"
		"\tmode: ggi mode string, like 640x490#800x900\n",prog);
	exit(1);
}

void stripevert(int x1,int y1,int x2,int y2,ggi_uint col1, ggi_uint col2, ggi_uint s)
{
	int x,xi;
	assert(s>0);

	ggiSetGCForeground(vis,col1);
	ggiDrawBox(vis,x1,y1,x2-x1+1,y2-y1+1);

	ggiSetGCForeground(vis,col2);
	for (x=x1; x<=x2;x+=s+s)
		for (xi=0; xi<s;xi++)
			ggiDrawVLine(vis,x+xi,y1,y2-y1+1);
}

void setcolors(void)
{
	/* just set the needed colour names */
	ggi_color col;
	ggi_mode mode;

	ggiGetMode(vis, &mode);

	/* If we're in indexed mode, the initial palette is undefined */
	if(GT_SCHEME(mode.graphtype)==GT_PALETTE) {
		ggiSetColorfulPalette(vis);
	}

	col.r=0xFFFF; col.g=0xFFFF; col.b=0xFFFF;
	white=ggiMapColor(vis, &col);

	col.r=0xFFFF; col.g=0xFFFF; col.b=0x0000;
	yellow=ggiMapColor(vis, &col);

	col.r=0xFFFF; col.g=0x0000; col.b=0xFFFF;
	magenta=ggiMapColor(vis, &col);

	col.r=0xFFFF; col.g=0x0000; col.b=0x0000;
	red=ggiMapColor(vis, &col);

	col.r=0x0000; col.g=0xFFFF; col.b=0xFFFF;
	cyan=ggiMapColor(vis, &col);

	col.r=0x0000; col.g=0xFFFF; col.b=0x0000;
	green=ggiMapColor(vis, &col);

	col.r=0x0000; col.g=0x0000; col.b=0xFFFF;
	blue=ggiMapColor(vis, &col);

	col.r=0x0000; col.g=0x0000; col.b=0x0000;
	black=ggiMapColor(vis, &col);
}

int circle(ggi_visual_t vis,int xcenter,int ycenter,int radius)
{
        /* easiest implementation, not time-optimised on weird archs. */
        int x,y,od,md,sd;

        /* original clipping code deleted. Leave clipping to ggiDrawPixel */
        /* shouldn't clip in this application anyway. */

        x=radius;y=md=0;
        while(x>=y) {
          ggiDrawPixel(vis,xcenter-y,ycenter-x);
          ggiDrawPixel(vis,xcenter+y,ycenter-x);
          ggiDrawPixel(vis,xcenter+x,ycenter-y);
          ggiDrawPixel(vis,xcenter-x,ycenter-y);
          ggiDrawPixel(vis,xcenter-x,ycenter+y);
          ggiDrawPixel(vis,xcenter+x,ycenter+y);
          ggiDrawPixel(vis,xcenter+y,ycenter+x);
          ggiDrawPixel(vis,xcenter-y,ycenter+x);
          od=md+y+y+1;sd=od-x-x-1;y++;md=od;
          if (abs(sd)<abs(od)) {x--;md=sd;}
        }

        return(0);
}

void testpattern(void)
{

#define PARTSHOR 16
#define PARTSVERT 12
#define PARTX(x) ((x)*(xmax-1)/PARTSHOR)
#define PARTWIDTH (xmax/PARTSHOR)
#define PARTY(y) ((y)*(ymax-1)/PARTSVERT)
#define PARTHEIGHT (ymax/PARTSVERT)
#define MIDX PARTX(PARTSHOR/2)
#define MIDY PARTY(PARTSVERT/2)

#define ggiDrawCircle(v,x,y,r) circle(v,x,y,r)

	int xmax, ymax;
	ggi_color col;
	int i;
	ggi_mode currmode;

	int FONTX, FONTY; /* used to be #defines */

	int xleft;
	int xright;
	int reddish=2,bluish=3,greenish=4,grey=5;
	int x,c;

	char s[255];

	ggiGetMode(vis,&currmode);
	xmax = currmode.visible.x;
	ymax = currmode.visible.y;

	ggiGetCharSize(vis, &FONTX, &FONTY);

	ggiSetGCForeground(vis,black);
	ggiFillscreen(vis);
	ggiSetGCForeground(vis,white);

	/* Grid */
	for (i=0;i<=PARTSHOR;i++) 
		ggiDrawVLine(vis,PARTX(i),0,ymax);
	for (i=0;i<=PARTSVERT;i++) {
		ggiDrawHLine(vis,0,PARTY(i),xmax);
	}

	ggiDrawCircle(vis,PARTX(1),PARTY(1),PARTHEIGHT);
	ggiDrawCircle(vis,PARTX(PARTSHOR-1),PARTY(1),PARTHEIGHT);
	ggiDrawCircle(vis,PARTX(1),PARTY(PARTSVERT-1),PARTHEIGHT);
	ggiDrawCircle(vis,PARTX(PARTSHOR-1),PARTY(PARTSVERT-1),PARTHEIGHT);
	ggiDrawCircle(vis,PARTX(PARTSHOR/2),PARTY(PARTSVERT/2),/*ymax/2*/
			(PARTY(PARTSVERT-1)-PARTY(1))/2);

	ggiSetGCForeground(vis,white);
	ggiDrawBox(vis,PARTX(PARTSHOR/2-4),PARTY(3)+1,
		   PARTX(PARTSHOR/2-3)-PARTX(PARTSHOR/2-4),
		   PARTY(5)-PARTY(3)-1);
	ggiSetGCForeground(vis,yellow);
	ggiDrawBox(vis,PARTX(PARTSHOR/2-3),PARTY(3)+1,
		   PARTX(PARTSHOR/2-2)-PARTX(PARTSHOR/2-3),
		   PARTY(5)-PARTY(3)-1);
	ggiSetGCForeground(vis,red);
	ggiDrawBox(vis,PARTX(PARTSHOR/2-2),PARTY(3)+1,
		   PARTX(PARTSHOR/2-1)-PARTX(PARTSHOR/2-2),
		   PARTY(5)-PARTY(3)-1);
	ggiSetGCForeground(vis,green);
	ggiDrawBox(vis,PARTX(PARTSHOR/2-1),PARTY(3)+1,
		   PARTX(PARTSHOR/2-0)-PARTX(PARTSHOR/2-1),
		   PARTY(5)-PARTY(3)-1);
	ggiSetGCForeground(vis,cyan);
	ggiDrawBox(vis,PARTX(PARTSHOR/2+0),PARTY(3)+1,
		   PARTX(PARTSHOR/2+1)-PARTX(PARTSHOR/2-0),
		   PARTY(5)-PARTY(3)-1);
	ggiSetGCForeground(vis,blue);
	ggiDrawBox(vis,PARTX(PARTSHOR/2+1),PARTY(3)+1,
		   PARTX(PARTSHOR/2+2)-PARTX(PARTSHOR/2+1),
		   PARTY(5)-PARTY(3)-1);
	ggiSetGCForeground(vis,magenta);
	ggiDrawBox(vis,PARTX(PARTSHOR/2+2),PARTY(3)+1,
		   PARTX(PARTSHOR/2+3)-PARTX(PARTSHOR/2+2),
		   PARTY(5)-PARTY(3)-1);
	ggiSetGCForeground(vis,black);
	ggiDrawBox(vis,PARTX(PARTSHOR/2+3),PARTY(3)+1,
		   PARTX(PARTSHOR/2+4)-PARTX(PARTSHOR/2+3),
		   PARTY(5)-PARTY(3)-1);
	
	xleft=PARTX(PARTSHOR/2-4)+1;
	xright=PARTX(PARTSHOR/2+4)-1;

	for (x=xleft;x<=xright;x++){
		c=((xright-x)*0xFFFF)/(xright-xleft);
		col.r=c; col.g=c; col.b=c;
		grey=ggiMapColor(vis, &col);
		col.r=c; col.g=0; col.b=0;
		reddish=ggiMapColor(vis, &col);
		col.r=0; col.g=c; col.b=0;
		greenish=ggiMapColor(vis, &col);
		col.r=0; col.g=0; col.b=c;
		bluish=ggiMapColor(vis, &col);
		ggiSetGCForeground(vis,reddish);
		ggiDrawVLine(vis,x,PARTY(PARTSVERT-5)+1,PARTHEIGHT/2);
		ggiSetGCForeground(vis,bluish);
		ggiDrawVLine(vis,x,PARTY(PARTSVERT-5)+1+PARTHEIGHT/2 ,
			     PARTHEIGHT/2);
		ggiSetGCForeground(vis,greenish);
		ggiDrawVLine(vis,x,PARTY(PARTSVERT-4)+1,PARTHEIGHT/2);
		ggiSetGCForeground(vis,grey);
		ggiDrawVLine(vis,x,PARTY(PARTSVERT-4)+1+PARTHEIGHT/2 ,
			     PARTHEIGHT/2);
	}

	stripevert(PARTX(0)+1,PARTY(0)+1,
		   PARTX(1)-1,PARTY(1)-1,black,white,1);
	stripevert(PARTX(PARTSHOR-1)+1,PARTY(0)+1,
		   PARTX(PARTSHOR)-1,PARTY(1)-1,black,white,1);
	stripevert(PARTX(0)+1,PARTY(PARTSVERT-1)+1,
		   PARTX(1)-1,PARTY(PARTSVERT)-1,black,white,1);
	stripevert(PARTX(PARTSHOR-1)+1,PARTY(PARTSVERT-1)+1,
		   PARTX(PARTSHOR)-1,PARTY(PARTSVERT)-1,black,white,1);
	
	stripevert(PARTX(PARTSHOR/2-4)+1,PARTY(PARTSVERT/2-1)+1,
		   PARTX(PARTSHOR/2-3)-1,PARTY(PARTSVERT/2)-1,black,white,1);
	stripevert(PARTX(PARTSHOR/2-4)+1,PARTY(PARTSVERT/2)+1,
		   PARTX(PARTSHOR/2-3)-1,PARTY(PARTSVERT/2+1)-1,black,red,1);
	stripevert(PARTX(PARTSHOR/2+3)+1,PARTY(PARTSVERT/2-1)+1,
		   PARTX(PARTSHOR/2+4)-1,PARTY(PARTSVERT/2)-1,black,green,1);
	stripevert(PARTX(PARTSHOR/2+3)+1,PARTY(PARTSVERT/2)+1,
		   PARTX(PARTSHOR/2+4)-1,PARTY(PARTSVERT/2+1)-1,black,blue,1);

	
	/* text output: */
	ggiSetGCForeground(vis,black);

	ggiDrawBox(vis,MIDX- 9*FONTX,MIDY-4*FONTY,18*FONTX,8*FONTY);


	ggiSetGCForeground(vis,white);
	ggiSetGCBackground(vis,black);


	ggiPuts(vis,MIDX-(15*FONTX)/2,MIDY-2*FONTY,"GGI screen test");

	/* -visible resolution */
	sprintf(s,"size: %4dx%3d",currmode.visible.x,currmode.visible.y);
	ggiPuts(vis,MIDX-(14*FONTX)/2,MIDY-0*FONTY,s);

	/* -virtual resolution */
	sprintf(s,"virt: %4dx%3d",currmode.virt.x,currmode.virt.y);
	ggiPuts(vis,MIDX-(14*FONTX)/2,MIDY+2*FONTY,s);


	ggiFlush(vis);
}

int main(int argc,char **argv)
{
	const char *prog=argv[0];
	
	int err;
	ggi_mode mo;
	int timeout=0;


	if (argc==1){
		
		/*mo=ggiDefaultMode; gives the default, I wish it existed */
		mo.virt.x=mo.virt.y=mo.visible.x=mo.visible.y=GGI_AUTO;
		mo.frames = GGI_AUTO; mo.graphtype=GT_AUTO;mo.dpp.x=mo.dpp.y=1;
 
	} else if (argc==2) {
		if (argv[1][0]=='-'){
			usage(prog);
			exit(1);
		}
		timeout=atoi(argv[1]); 
       
                /*mo=ggiDefaultMode; gives the default, I wish it existed */
		mo.virt.x=mo.virt.y=mo.visible.x=mo.visible.y=GGI_AUTO;
		mo.frames = GGI_AUTO; mo.graphtype=GT_AUTO;mo.dpp.x=mo.dpp.y=1;
 
	} else if (argc==3) {
		timeout=atoi(argv[1]); 
		ggiParseMode(argv[2],&mo);
	} else {
		usage(prog);
	}

	if (ggiInit() != 0) {
		fprintf(stderr, "%s: unable to initialize libggi, exiting.\n",
			argv[0]);
		exit(1);
	}
	if ((vis=ggiOpen(NULL)) == NULL) {
		fprintf(stderr,
			"%s: unable to open default visual, exiting.\n",
			argv[0]);
		exit(1);
	}
	ggiSetFlags(vis, GGIFLAG_ASYNC);


	printf("Trying mode ");
	ggiPrintMode(&mo);
	printf("\n");

	ggiCheckMode(vis,&mo);

	printf("Suggested mode ");
	ggiPrintMode(&mo);
	printf("\n");

	err=ggiSetMode(vis,&mo);

	if (err) {
		fprintf(stderr,"Can't set mode\n");
		return 2;
	}

	setcolors();

	testpattern();

	if (timeout <=0){
		ggiGetc(vis);
	} else {
		sleep((unsigned int)timeout);
	}


	ggiClose(vis);

	ggiExit();	

	return 0;
}
