/* File "commands.h":
 * Support for a command line interpreter. */

/* This file is part of Malaga, a system for Left Associative Grammars.
 * Copyright (C) 1995-1998 Bjoern Beutel
 *
 * Bjoern Beutel
 * Universitaet Erlangen-Nuernberg
 * Abteilung fuer Computerlinguistik
 * Bismarckstrasse 12
 * D-91054 Erlangen
 * e-mail: malaga@linguistik.uni-erlangen.de 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* types ====================================================================*/

/* Use a vector of "command_t" command descriptions
 * (terminated by a {NULL, NULL} entry) as argument for "command_loop". */ 
typedef struct
{
  string_t names;                       /* the command name followed by its
					 * shortcuts, separated by spaces */
  void (*command) (string_t arguments); /* the command function */
  string_t help;                        /* help string or NULL */
} command_t; 

/* variables ================================================================*/

GLOBAL jmp_buf *error_jump_point; /* the current return point after an error */

GLOBAL command_t **options;
/* The options that can be set by the set command.
 * This has to be set before executing "set_command". */

GLOBAL bool_t quit_requested; /* TRUE if quit command has been executed */
GLOBAL bool_t leave_command_loop; /* set to TRUE if command loop is to leave */

/* functions for user interrupts ============================================*/

extern void check_user_break (void);
/* Abort command execution if user has sent an interrupt signal. */

/* functions for reading and executing commands =============================*/

extern void execute_command_file (string_t command_file, string_t line_header, 
				  command_t *commands[]);
/* Execute commands in <command_file> using <commands>.
 * If <line_header> != NULL, command lines must start with <line_header>. */

extern void command_loop (string_t prompt, command_t *commands[]);
/* Read user commands, look for them in <commands> and execute them
 * until a command returns FALSE. */

extern void execute_set_commands (string_t file_name, string_t prefix);
/* Execute set commands in file <file_name> that are prefixed with <prefix>. */

/* general commands =========================================================*/

extern command_t help_command; /* Print a command summary. */

extern command_t quit_command; /* Quit the program. */

extern command_t get_command; /* Query options. */

extern command_t set_command; /* Set options. */

extern command_t alias_option; /* Define command line abbreviations. */
