/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_mutex.c,v 1.2 1999/02/20 00:54:47 slouken Exp $";
#endif

/* Semaphore locking in the BeOS environment */

#include <be/kernel/OS.h>

#include "SDL_error.h"
#include "SDL_mutex.h"


struct SDL_mutex {
	sem_id id;
};

/* Create a counting semaphore */
SDL_mutex *SDL_CreateMutex(void)
{
	SDL_mutex *mutex;

	mutex = (SDL_mutex *)malloc(sizeof(*mutex));
	if ( mutex == NULL ) {
		SDL_SetError("Out of memory");
		return(NULL);
	}
	mutex->id = create_sem(1, "SDL mutex");
	if ( mutex->id < B_NO_ERROR ) {
		SDL_SetError("Couldn't create semaphore");
		free(mutex);
		return(NULL);
	}
	return(mutex);
}

/* Lock the semaphore */
int SDL_mutexP(SDL_mutex *mutex)
{
	if ( ! mutex ) {
		SDL_SetError("Passed a NULL mutex");
		return(-1);
	}
  tryagain:
	switch (acquire_sem(mutex->id)) {
		case B_INTERRUPTED:
			goto tryagain;
		case B_NO_ERROR:
			return(0);
		default:
			return(-1);
	}
}

/* Unlock the semaphore */
int SDL_mutexV(SDL_mutex *mutex)
{
	if ( ! mutex ) {
		SDL_SetError("Passed a NULL mutex");
		return(-1);
	}
	if ( release_sem(mutex->id) != B_NO_ERROR ) {
		SDL_SetError("Semaphore operation error");
		return(-1);
	}
	return(0);
}

/* Free the semaphore */
void SDL_DestroyMutex(SDL_mutex *mutex)
{
	if ( mutex ) {
		delete_sem(mutex->id);
		free(mutex);
	}
}
