/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: macmain.c,v 1.9 1999/07/27 04:38:23 slouken Exp $";
#endif

/* This file takes care of command line argument parsing, and stdio redirection
   in the MacOS environment.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>	
#include <Dialogs.h>
#include <Fonts.h>
#include <Events.h>
#include <Resources.h>


/* Make sure we don't get the wrong version of SDL_DEFUN() */
#ifdef _BUILDING_SDL
#undef _BUILDING_SDL
#endif

#include "SDL.h"

/* The standard output files */
#define STDOUT_FILE	"stdout.txt"
#define STDERR_FILE	"stderr.txt"

/* In MPW, the qd global has been removed from the libraries */
QDGlobals qd;

/* From the SDL library code */
SDL_DEFUN(void, SDL_InitQuickDraw, (QDGlobals *the_qd))

/* Parse a command line buffer into arguments */
static int ParseCommandLine(char *cmdline, char **argv)
{
	char *bufp;
	int argc;

	argc = 0;
	for ( bufp = cmdline; *bufp; ) {
		/* Skip leading whitespace */
		while ( isspace(*bufp) ) {
			++bufp;
		}
		/* Skip over argument */
		if ( *bufp == '"' ) {
			++bufp;
			if ( *bufp ) {
				if ( argv ) {
					argv[argc] = bufp;
				}
				++argc;
			}
			/* Skip over word */
			while ( *bufp && (*bufp != '"') ) {
				++bufp;
			}
		} else {
			if ( *bufp ) {
				if ( argv ) {
					argv[argc] = bufp;
				}
				++argc;
			}
			/* Skip over word */
			while ( *bufp && ! isspace(*bufp) ) {
				++bufp;
			}
		}
		if ( *bufp ) {
			if ( argv ) {
				*bufp = '\0';
			}
			++bufp;
		}
	}
	if ( argv ) {
		argv[argc] = NULL;
	}
	return(argc);
}

#undef main
/* This is where execution begins */
int main(int argc, char *argv[])
{
	int nargs;
	char **args;
	short itemHit;
	Handle dummyHandle;
	DialogPtr commandDialog, errorDialog;
	Handle	commandLineHandle;
	Boolean	captureFile;
	Str255	commandText;
	char   *commandLine;
	int     commandLineLen;
	long	i;

	/* Hush little compiler don't you cry,
	   Momma's gonna use argc, and I don't know why.
	   La la la la la la la la...
	 */
	if ( argc > 1 ) {
		/* Hum, command line arguments? */
	}

	/* Kyle's SDL command-line dialog code ... */
	InitGraf(&qd.thePort);
	InitFonts();
	InitWindows();
	InitMenus();
	InitDialogs(nil);
	InitCursor();
	FlushEvents(everyEvent,0);
	MaxApplZone();
	MoreMasters();	/* What is this?? */
	MoreMasters();	/* What is this?? */

	/* Intialize SDL, and put up a dialog if we fail */
	if ( SDL_Init(0) < 0 ) {
#define kErr_OK		1
#define kErr_Text	2
		errorDialog = GetNewDialog(1001, nil, (WindowPtr)-1);
		DrawDialog( errorDialog );
		GetDialogItem(errorDialog, kErr_Text, NULL,&dummyHandle,NULL);
		SetDialogItemText(dummyHandle, "\pError Initializing SDL");
		SetPort( errorDialog );
		do {
			ModalDialog( nil, &itemHit);
		} while ( itemHit != kErr_OK );
		CloseDialog( errorDialog );
		exit(-1);
	}
	atexit(SDL_Quit);

	/* Set up SDL's QuickDraw environment */
	SDL_InitQuickDraw(&qd);

	commandLineHandle = Get1Resource( 'CLne', 128 );
	if (commandLineHandle != NULL) {
		HLock(commandLineHandle);
		/* CLne resource consist of a pascal string and a boolean */
		for ( i = 0; (i <= (*commandLineHandle)[0]) &&
		            (i < GetHandleSize(commandLineHandle)); i++ ) {
			commandText[i] = (*commandLineHandle)[i];
		}
		captureFile = (*commandLineHandle)[i];
		ReleaseResource( commandLineHandle );
	
	} else {
#define kCL_OK		1
#define kCL_Cancel	2
#define kCL_Text	3
#define kCL_File	4
		commandDialog = GetNewDialog( 1000, nil, (DialogPtr)-1 );
		SetPort(commandDialog);
		GetDialogItem(commandDialog, kCL_File, NULL,&dummyHandle,NULL);
		SetControlValue((ControlHandle)dummyHandle, true );
		do {
			ModalDialog(nil, &itemHit);
			if ( itemHit == kCL_File ) {
				GetDialogItem(commandDialog, kCL_File, NULL, &dummyHandle, NULL);
				SetControlValue((ControlHandle)dummyHandle, !GetControlValue((ControlHandle)dummyHandle) );
			}
		} while (itemHit != kCL_OK && itemHit != kCL_Cancel);
		GetDialogItem(commandDialog, kCL_Text, NULL,&dummyHandle,NULL);
		GetDialogItemText(dummyHandle, commandText);
		GetDialogItem(commandDialog, kCL_File, NULL,&dummyHandle,NULL);
		captureFile = GetControlValue((ControlHandle)dummyHandle);
		CloseDialog(commandDialog);

		if (itemHit == kCL_Cancel ) {
			exit(0);
		}
	}

	/* Redirect standard I/O to files */
	if ( captureFile ) {
		freopen(STDOUT_FILE, "w", stdout);
		freopen(STDERR_FILE, "w", stderr);
	} else {
		fclose(stdout);
		fclose(stderr);
	}

	/* Copy the command line to a C string */
	commandLineLen = strlen(argv[0]) + 1 + commandText[0] + 1;
	commandLine = (char *)malloc(commandLineLen);
	if ( commandLine == NULL ) {
		exit(-1);
	}
	strcpy(commandLine, argv[0]);
	if ( commandText[0] ) {
		strcat(commandLine, " ");
		strncat(commandLine, (char *)&commandText[1], commandText[0]);
	}
	commandLine[commandLineLen-1] = '\0';

	/* Parse it into argv and argc */
	nargs = ParseCommandLine(commandLine, NULL);
	args = (char **)malloc((nargs+1)*(sizeof *args));
	if ( args == NULL ) {
		exit(-1);
	}
	ParseCommandLine(commandLine, args);

	/* Run the main application code */
	RunMain(nargs, args);
	free(args);
	free(commandLine);

	/* Exit cleanly, calling atexit() functions */
	exit(0);

	/* Never reached, but keeps the compiler quiet */
	return(0);
}

