/*
 * $Id: hashtable.h,v 1.2 1999/07/10 12:58:28 mario Exp $
 *
 * Copyright (c) Paul D. Gear
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA  02111-1307  USA, or go to
 * <http://www.gnu.org/copyleft/lgpl.html> on the World Wide Web.
 *
 */

/*
 * Brief:       Hash table for VDK implemented using glib's GHashTable.
 * Author:      Paul D. Gear
 * Created:	Sat Jun 26 17:13:42 EST 1999
 *
 * Bugs:	The GLib hash table functions don't seem to have a concept of
 *		returning an error code on failures, so we can't really check
 *		for them.
 *
 * Enhancements:
 *		Unimplemented g_hash_table_... functions need implementing.
 *
 * See Also:	http://www.gtk.org/rdp/glib/glib-hash-tables.html
 */

#ifndef __vdk_hashtable_H__
#define __vdk_hashtable_H__

#include <glib.h>


template <class KEY, class DATA>
class VDKHashTable
{

//
// Instance variables:
//
protected:
    GHashTable *table;

//
// Instance methods:
//
public:
    // Create an empty hash table
    VDKHashTable( GHashFunc hash_func = NULL,
	GCompareFunc key_compare_func = NULL )
    {
	table = g_hash_table_new( hash_func, key_compare_func );
    }

    // Destroy the hash table
    virtual ~VDKHashTable()
    {
	g_hash_table_destroy( table );
    }

    // Insert a (key,data) pair into the hash table
    virtual void Insert( KEY *key, DATA *data )
    {
	g_hash_table_insert( table, key, data );
    }

    /// Remove the (key,data) pair with the matching key
    virtual void Remove( const KEY *key )
    {
	g_hash_table_remove( table, key );
    }

    // Find the data associated with the given key
    virtual DATA *Lookup( const KEY *key )
    {
	return (DATA *)g_hash_table_lookup( table, key );
    }

    // Disable resizing of the hash table.
    virtual void Freeze()
    {
	g_hash_table_freeze( table );
    }

    // Enable resizing of the hash table
    virtual void Thaw()
    {
	g_hash_table_thaw( table );
    }

    // Return the number of (key,data) pairs in the table
    virtual guint GetSize()
    {
	return g_hash_table_size( table );
    }

    //g_hash_table_lookup_extended not implemented
    //g_hash_table_foreach not implemented
    //g_hash_table_foreach_remove not implemented

};


#endif	/* __vdk_hashtable_H__ */
