#include <vdk/vdk.h>
#include <shaped_button.h>

class MyMaskForm: public VDKForm
{
public:
  MyMaskForm(VDKApplication *app):
	VDKForm(app){};
  ~MyMaskForm(){};
  void Setup();
  VDKShapedButton *button1;
  VDKLabelButton *button2;
  
  bool OnClick(VDKObject *obj){
	switch(obj->Tag){
	case 0:
	  printf("Shaped Button clicked.\n");
	  break;
	case 1:
	  printf("Normal Button clicked.\n");
	  break;
	default:
	  printf("What's this ?!?\n");
	  break;
	}
	return true;
  }
  DECLARE_SIGNAL_MAP(MyMaskForm);
};

DEFINE_SIGNAL_MAP(MyMaskForm,VDKForm)
  ON_SIGNAL(button1, clicked_signal, OnClick),
  ON_SIGNAL(button2, clicked_signal, OnClick)
END_SIGNAL_MAP

void
MyMaskForm::Setup()
{
  button1 = 
	new VDKShapedButton(this, "kill.xpm", "killh.xpm", "Cool Shaped Button");
  button2 =
	new VDKLabelButton(this, "Normal Button", "Normal Button");

  button1->Tag = 0;
  button2->Tag = 1;
  
  Add(button1);
  Add(button2);
}

//////////////////////////////
// The VDKApplication
//////////////////////////////
class MyMaskApp: public VDKApplication
{
public:
  MyMaskApp(int *argc, char *argv[]):VDKApplication(argc, argv){
  };
  ~MyMaskApp(){};
  void Setup(){
	MainForm = new MyMaskForm(this);
	MainForm->Setup();
	MainForm->Show();
  }
};
//////////////////////////////
// The main function
//////////////////////////////
int main (int argc, char *argv[])
{
  MyMaskApp app(&argc, argv);
  app.Run();
  return 0;
}
