/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.6.1
 * May 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 * Modified by Tamas Kohegyi <tamas.kohegyi@unforgettable.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public 
 * License as published by the Free Software Foundation; either 
 * version 2 of the License, or (at your option) any later version. 
 * 
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
 * Library General Public License for more details. 
 * 
 * You should have received a copy of the GNU Library General Public 
 * License along with this library; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 */ 
 
#ifndef  CANVAS_H 
#define  CANVAS_H  
 
#include <vdk/vdkobj.h> 
#include <vdk/colors.h> 
#include <vdk/rawpixmap.h> 
 
class VDKCanvas: public VDKObject 
{ 
 protected:
  bool dragFlag,startdragFlag; 
  VDKColor* background; 
  bool setFg,setBg,setF; 
  GdkGC *gc;
  void DrawBackground(); 
 public: 
  static int ConfigureEvent(GtkWidget* w, GdkEventConfigure* event, void* o); 
  static int ExposeEvent(GtkWidget* w, GdkEventExpose* event, void* o); 
  static int ButtonPressEvent(GtkWidget* w, GdkEventButton* event, void* o); 
  static int ButtonReleaseEvent(GtkWidget* w, GdkEventButton* event, void* o); 
  static int MotionNotifyEvent(GtkWidget* w, GdkEventMotion* event, void* o); 
   
  GdkPixmap *pixmap;   // buffered pixmap 
  void Reset();        // recreate the buffered bixmap 

/* 
 * properties 
 */ 
 
  VDKReadWriteValueProp<VDKCanvas,bool> Captured; 
  VDKReadWriteValueProp<VDKCanvas,bool> EnableDrag; 
  VDKReadWriteValueProp<VDKCanvas,bool> EnableClear; 
 
 public: 
  VDKCanvas(VDKForm* owner, int w = 100, int h = 100); 
  virtual ~VDKCanvas(); 
  void Clear(); 
  void DrawString(int x, int y, char* text); 
  void DrawText(int x, int y, char* text, int n); 
  void DrawPoint(int x, int y); 
  void DrawLine(int x, int y, int x1, int y1); 
  void DrawRect(int filled,int x, int y, int w, int h); 
  void DrawArc(int filled,int x,int y, int width,  
	       int height,int angle1, int angle2); 
  void DrawPolygon(int filled,GdkPoint *points, gint npoints); 
  void DrawPoints(GdkPoint *points, int npoints); 
  void DrawSegments(GdkSegment *segs, int nsegs); 
  void DrawLines(GdkPoint *points, int npoints); 
  void DrawPixmap(int x, int y, char *pixfile); 
  void DrawPixmap(int x, int y, VDKRawPixmap* pix); 
  void DrawPixmap(int x, int y, char ** data); 
  void Redraw(); // with no expose  
  // with no expose 
  void SetForeground(VDKRgb color, GtkStateType state = GTK_STATE_NORMAL);
  void SetBackground(VDKRgb color, GtkStateType state = GTK_STATE_NORMAL);
  void SetFont(VDKFont* f) { setF = true; VDKObject::SetFont(f); }  
}; 
 
#endif 



