/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef FILEDLG_H
#define FILEDLG_H
#include <vdk/forms.h>
#include <vdk/evhandle.h>

class VDKFileSel: public VDKForm
{

  VDKFileSel(VDKApplication* app,
	     char* selection,
	     gchar* title = NULL,
	     GtkWindowType display = GTK_WINDOW_TOPLEVEL);
 protected:
  GtkWidget* fileSel;
  VDKObject* ok_button,*cancel_button;
  VDKObjectSignal ok_s_clicked;
  VDKObjectSignal cancel_s_clicked;
  char* selection;
 public:
  VDKFileSel(VDKForm* owner,
	     char* selection,
	     gchar* title = "");
  virtual ~VDKFileSel();
  // placeholders
  virtual void OnExpose( VDKForm*, GdkRectangle) {}
  virtual void OnRealize(VDKForm*) {} 
  virtual void Setup() {}
  bool Ok(VDKObject*);
  bool Cancel(VDKObject*);
  void Show() { VDKForm::ShowModal();}
  DECLARE_SIGNAL_MAP(VDKFileSel);
};
#endif
