/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  PIXMAPS_H
#define  PIXMAPS_H

#include <vdk/vdkobj.h>
class VDKTooltip;
class VDKRawPixmap;

class VDKPixmap: public VDKObject
{

protected:
  int width,height;
  GdkPixmap* pixmap;
  GtkWidget* pixmapWid;
  VDKTooltip* tip;
  VDKRawPixmap* oldRawPix;
public:
  VDKPixmap(VDKForm* owner,
	    char* pixfile, 
	    char* tip = NULL);
  VDKPixmap(VDKForm* owner,
	    char** pixdata, 
	    char* tip = NULL);
  virtual ~VDKPixmap();
  void Clear();
  int Width() { return width; }
  int Height() { return height; }
  VDKRawPixmap* SetPixmap() { return oldRawPix; }
  VDKRawPixmap* SetPixmap(char* file);
  VDKRawPixmap* SetPixmap(VDKRawPixmap* newpix);
  VDKRawPixmap* SetPixmap(char** pixdata);
};
#endif
