/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef RAWPIXMAP_H
#define RAWPIXMAP_H
#include <vdk/vdkobj.h>
#include <vdk/rawobj.h>
class VDKObject;
class VDKForm;

class VDKRawPixmap : public VDKRawObject
{
 protected:
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  GtkStyle  *style;
  int w,h;
  VDKPoint lastDraw;
 public:
  VDKRawPixmap(VDKObject* owner, char* pixfile);
  VDKRawPixmap(VDKObject* owner, char** pixdata);
  //  VDKRawPixmap(VDKForm* ownerForm, char* pixfile);
  //VDKRawPixmap(VDKForm* ownerForm, char** pixdata);

  virtual ~VDKRawPixmap();
  operator GdkPixmap*() { return pixmap; }
  GdkBitmap* Mask() { return mask; }
  GtkStyle*  Style() { return style; }
  //void Clear();
  void Paint(int x, int y);
  void Paint(bool lastdraw=true, GdkWindow* window=0, int x = 0, int y = 0);
  int Width() { return w; }
  int Height() { return h; }
};

#endif



