/* -*- c++ -*- */
/*
 * ===========================
 * VDK Visual Development Kit
 * Version 1.0.3
 * November 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _sigc_addon_h_
#define _sigc_addon_h_
#include <sigc++/signal_system.h>

#ifdef SIGC_CXX_NAMESPACES // currently code depends on this!
using namespace std;
using namespace SigC;
#endif

/** This template basically makes a signal of type:
             Signal2<Ret, VDKObject*, P1>
    what also accepts slots of type:
             Slot1<Ret,P1>
    for VDKSignal1<Ret, P1>.
    Attention: To emit a signal like this you have to call
    'emit(VDKObject* ob, P1)' , that means 'emit(P1)' is not available.
    Must be as we must handle all subscribed signal_receivers equal.
    This nameing convention also applies on the other classes, so
    VDKSignal0<Ret> wraps Signal0<Ret> and Signal1<Ret, VDKObject*>.
*/

/*! must introduce an internal connection so that slots will work fine */
/*! This template should never be used as signals with a signature of
    this type will be covered by vdk's own signal-system */
template<class Ret>
class VDKSignal0 : public SigC::Signal1<Ret, VDKObject*>,
		   public SigC::Signal0<Ret>
{
private:
/*     Ret emit(){}; // Don't use!!! */
/*     Ret operator()(){} // also */
public:
     Connection connect(const Slot0<Ret> &sl)
     {return Signal0<Ret>::connect(sl);}
     Connection connect(const Slot1<Ret, VDKObject*> &sl)
     {return Signal1<Ret,VDKObject*>::connect(sl);}

     Ret emit(VDKObject* obj)
     {Signal0<Ret>::emit();
     return Signal1<Ret,VDKObject*>::emit(obj);}

     Ret operator()(VDKObject* obj)
     {Signal0<Ret>::emit();
     return Signal1<Ret,VDKObject*>::emit(obj);}

/*     
     Slot1<Ret, VDKObject*> slot()
	{return SigC::slot(*this, VDKSignal0<Ret>::emit);}
*/
};

// template<class Ret>
// Ret return_default<Ret>();


// template<class Ret>
// class VDKSignal0 : public SigC::Signal1<Ret, VDKObject*>
// {
// private:
//      SigC::Signal0<Ret> _sigs;

//      Ret _shadow_handler(VDKObject*)
//      {_sigs.emit();}

// public:
//      VDKSignal0()
//      {connect(slot(*this, &VDKSignal0<Ret>::_shadow_handler));}

//      Connection connect(const Slot0<Ret> &sl)
//      {return _sigs.connect(sl);}
// };

template<class Ret, class P1>
class 
VDKSignal1 : public SigC::Signal2<Ret, VDKObject*, P1>,
	     public SigC::Signal1<Ret, P1>
{
private:
     Ret emit(P1){}; // Don't use!!!
     Ret operator()(P1){} // also 
public:
     Connection connect(const Slot1<Ret, P1> &sl)
     {return Signal1<Ret,P1>::connect(sl);}
     Connection connect(const Slot2<Ret, VDKObject*, P1> &sl)
     {return Signal2<Ret,VDKObject*,P1>::connect(sl);}

     Ret emit(VDKObject* obj, P1 par1)
     {Signal1<Ret,P1>::emit(par1);
     return Signal2<Ret,VDKObject*,P1>::emit(obj, par1);}

     Ret operator()(VDKObject* obj, P1 par1)
     {Signal1<Ret,P1>::emit(par1);
     return Signal2<Ret,VDKObject*,P1>::emit(obj, par1);}
/*
     Slot2<Ret, VDKObject*, P1> slot()
	{return SigC::slot(*this, &VDKSignal1<Ret,P1>::emit);}
*/
};

// template<class Ret, class P1>
// class VDKSignal1 : public SigC::Signal2<Ret, VDKObject*, P1>
// {
// private:
//      SigC::Signal1<Ret, P1> _sigs;
  
//      Ret _shadow_handler(VDKObject*, P1 par1)
//      {_sigs.emit(par1);} // Hopefully return correct default value

// public:
//      VDKSignal1()
//      {connect(slot(*this, &VDKSignal1<Ret,P1>::_shadow_handler));}

//      Connection connect(const Slot1<Ret,P1> &sl)
//      {return _sigs.connect(sl);}
// };   


template<class Ret, class P1, class P2>
class 
VDKSignal2 : public SigC::Signal3<Ret, VDKObject*, P1, P2>,
	     public SigC::Signal2<Ret, P1, P2>
{
private:
     Ret emit(P1, P2){}; // Don't use!!!
     Ret operator()(P1, P2){} // also
public:
     Connection connect(const Slot2<Ret, P1, P2> &sl)
     {return Signal2<Ret, P1, P2>::connect(sl);}
     Connection connect(const Slot3<Ret, VDKObject*, P1, P2> &sl)
     {return Signal3<Ret,VDKObject*,P1, P2>::connect(sl);}

     Ret emit(VDKObject* obj, P1 par1, P2 par2)
     {Signal2<Ret, P1, P2>::emit(par1,par2);
     return Signal3<Ret,VDKObject*,P1,P2>::emit(obj, par1, par2);}

     Ret operator()(VDKObject* obj, P1 par1, P2 par2)
     {Signal2<Ret, P1, P2>::emit(par1, par2);
     return Signal3<Ret,VDKObject*,P1, P2>::emit(obj, par1, par2);}
/*     
     Slot3<Ret, VDKObject*, P1, P2> slot()
     {return Signal3<Ret, VDKObject*,  P1, P2>::slot();}
*/
};

// template<class Ret, class P1, class P2>
// class VDKSignal2 : public SigC::Signal3<Ret, VDKObject*, P1, P2>
// {
// private:
//      SigC::Signal2<Ret, P1, P2> _sigs;
  
//      Ret _shadow_handler(VDKObject*, P1 par1, P2 par2)
//      {_sigs.emit(par1, par2);}

// public:
//      VDKSignal2()
//      {connect(slot(*this, &VDKSignal2<Ret,P1,P2>::_shadow_handler));}

//      Connection connect(const Slot2<Ret,P1,P2> &sl)
//      {return _sigs.connect(sl);}
// };   

template<class Ret, class P1, class P2, class P3>
class 
VDKSignal3 : public SigC::Signal4<Ret, VDKObject*, P1, P2, P3>,
	     public SigC::Signal3<Ret, P1, P2, P3>
{
private:
     Ret emit(P1, P2, P3){}; // Don't use!!!
     Ret operator()(P1, P2, P3){} // also
public:
     Connection connect(const Slot3<Ret, P1, P2, P3> &sl)
     {return Signal3<Ret, P1, P2, P3>::connect(sl);}
     Connection connect(const Slot4<Ret, VDKObject*, P1, P2, P3> &sl)
     {return Signal4<Ret,VDKObject*,P1, P2, P3>::connect(sl);}

     Ret emit(VDKObject* obj, P1 par1, P2 par2, P3 par3)
     {Signal3<Ret, P1, P2, P3>::emit(par1,par2.par3);
     return Signal4<Ret,VDKObject*,P1,P2,P3>::emit(obj,par1,par2,par3);}

     Ret operator()(VDKObject* obj, P1 par1, P2 par2, P3 par3)
     {Signal3<Ret, P1, P2, P3>::emit(par1, par2, par3);
     return Signal4<Ret,VDKObject*,P1, P2, P3>::emit(obj,par1,par2,par3);}
/*     
     Slot4<Ret, VDKObject*, P1, P2, P3> slot()
     {return Signal4<Ret,VDKObject*,P1, P2, P3>::slot();}
 */
};

// template<class Ret, class P1, class P2, class P3>
// class VDKSignal3 : public SigC::Signal4<Ret, VDKObject*, P1, P2, P3>
// {
// private:
//      SigC::Signal3<Ret, P1, P2, P3> _sigs;
  
//      Ret _shadow_handler(VDKObject*, P1 par1, P2 par2, P3 par3)
//      {_sigs.emit(par1, par2, par3);}

// public:
//      VDKSignal3()
//      {connect(slot(*this, &VDKSignal3<Ret,P1,P2,P3>::_shadow_handler));}

//      Connection connect(const Slot3<Ret,P1,P2,P3> &sl)
//      {return _sigs.connect(sl);}
// };   
#endif






