/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  TOOLBAR_H
#define  TOOLBAR_H


#include <vdk/vdkprops.h>
#include <vdk/widcontain.h>
#include <gtk/gtkenums.h>

class VDKForm;
class VDKBox;


typedef VDKList<VDKObject>           ToolWidgetList;
typedef VDKListiterator<VDKObject>   ToolWidgetListIterator;
typedef VDKList<GtkWidget>           GtkWidgetList;
typedef VDKListiterator<GtkWidget>   GtkWidgetListIterator;

class VDKToolbar : public VDKObjectContainer 
{

  static void ButtonSignal(GtkWidget *wid, gpointer gp);
  ToolWidgetList toolWidgets;
  GtkWidgetList  widgets;
  VDKList<VDKObject>           tool_buttons;

public:
    // properties
    VDKReadOnlyValueProp<VDKToolbar, ToolWidgetList*>  WidgetList;
    VDKReadOnlyValueProp<VDKToolbar, GtkWidgetList*>   ButtonList;
    VDKReadOnlyValueProp<VDKToolbar, int>              ButtonPressed;
    VDKReadWriteValueProp<VDKToolbar, GtkOrientation>  Orientation;
    VDKReadWriteValueProp<VDKToolbar, GtkToolbarStyle> Style;
    VDKReadWriteValueProp<VDKToolbar, GtkToolbarSpaceStyle> SpaceStyle;
    VDKReadWriteValueProp<VDKToolbar, bool>            Borderless;
    VDKReadWriteValueProp<VDKToolbar, GtkReliefStyle>  Relief;
    VDKReadWriteValueProp<VDKToolbar, int>             Spacing;
    //
    VDKToolbar(VDKForm* owner, GtkOrientation orientation = GTK_ORIENTATION_HORIZONTAL);
    virtual ~VDKToolbar() {}
    virtual void Add(VDKObject* obj, int , int , int , int )
      { AddWidget(obj); }

    void AddWidget(VDKObject* widget, char* tip = NULL);
    
    void AddButton(char** pixdata,
                   char* tip = NULL,
                   char* text = NULL);

    void AddButton(char* pixfile,
                   char* tip = NULL,
                   char* text = NULL);

    void AddSpace() {
        gtk_toolbar_append_space(GTK_TOOLBAR(widget));
    }

    void SetOrientation( GtkOrientation orientation) {
        gtk_toolbar_set_orientation(GTK_TOOLBAR(widget),orientation);
    }

    void SetStyle(GtkToolbarStyle style) {
        gtk_toolbar_set_style(GTK_TOOLBAR(widget),style);
    }

    void SetBorderless(bool flag) {
        if(!flag)
            gtk_toolbar_set_button_relief (GTK_TOOLBAR (widget), GTK_RELIEF_NORMAL);
        else
            gtk_toolbar_set_button_relief (GTK_TOOLBAR (widget), GTK_RELIEF_NONE);
    }

    void SetSpacing(int s) {
        gtk_toolbar_set_space_size(GTK_TOOLBAR(widget),s);
    }

    void SetRelief(GtkReliefStyle style) {
        gtk_toolbar_set_button_relief (GTK_TOOLBAR(widget), style);
    }

    GtkReliefStyle GetRelief () {
        return gtk_toolbar_get_button_relief (GTK_TOOLBAR(widget));
    }

    void SetSpaceStyle(GtkToolbarSpaceStyle style) {
        gtk_toolbar_set_space_style (GTK_TOOLBAR (widget), style);
    }

    GtkToolbarSpaceStyle GetSpaceStyle() {
        return GTK_TOOLBAR(widget)->space_style;
    }
    
    VDKObject* operator[](int ndx) {
        if( (ndx >= 0) && (ndx < tool_buttons.size()) )
            return tool_buttons[ndx];
        else
            return NULL;
    }
};


#endif









