/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.5
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 

#ifndef VDKCUSTOM_H
#define VDKCUSTOM_H
#include <vdk/vdkobj.h>
#include <vdk/value_sem_list.h>
#include <vdk/vdkarray.h>
#include <vdk/colors.h>
#include <vdk/vdkprops.h>
#ifndef _string_array_def
#define _string_array_def
typedef VDKArray<VDKString> StringArray;
#endif
/*
 */
class Tuple: public StringArray
{
  int KeyIndex;
 public:
  
  Tuple(int n = 0, int key = 0): StringArray(n),KeyIndex(key) {}
  virtual ~Tuple() {}
  int operator <(Tuple& t) 
    { 
      return (*this)[KeyIndex] < t[KeyIndex]; 
    }
  int operator==(Tuple& t)
    { 
      return (*this)[KeyIndex] == t[KeyIndex]; 
    }
  
};

/*
 */
typedef VDKValueList<Tuple>         TupleList;  
typedef VDKValueListIterator<Tuple> TupleListIterator;
typedef VDKArray<VDKObject*>        VDKObjectArray;
typedef VDKArray<int>               IntArray;
/*
 */
class VDKCustom: public VDKObject
{
 protected:
  int select_connect,unselect_connect;
 public:
  // properties
  VDKReadWriteValueProp<VDKCustom,GtkPolicyType> VPolicy;
  VDKReadWriteValueProp<VDKCustom,GtkPolicyType> HPolicy;
  VDKReadWriteValueProp<VDKCustom,GtkShadowType> BorderShadow;
  VDKReadWriteValueProp<VDKCustom,int> RowHeight;
  VDKReadWriteValueProp<VDKCustom,bool> AutoResize;
  VDKObjectArray Titles;
  int SelectedTitle; 
  VDKColor *UnselectedBackground,
    *UnselectedForeground,
    *SelectedBackground,
    *SelectedForeground;

 protected:
  GtkWidget* custom_widget;
  int columns;
  GtkSelectionMode mode;
  virtual void ConnectSignals();
  static void ColumnClick(GtkWidget* , gint column, gpointer s);
  void SetRowHeight(int rh)
    { gtk_clist_set_row_height(GTK_CLIST(custom_widget),rh); }
  void SetAutoResize(bool flag);
  GtkPolicyType GetVPolicy()   { return VPolicy; }
  GtkPolicyType GetHPolicy()   { return HPolicy; }
    //
  void SetVPolicy(GtkPolicyType p)
    {
      gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (widget),
				      HPolicy, 
				      p);
    }
  void SetHPolicy(GtkPolicyType p)
    { 
      gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (widget),
				      p, 
				      VPolicy);
    }
  void SetBorderShadow(GtkShadowType bs)
    { gtk_clist_set_shadow_type (GTK_CLIST(custom_widget),bs); }
  GtkShadowType GetBorderShadow() { return BorderShadow; }

 public:
  VDKCustom(VDKForm* owner,
	    int columns = 1,
	    char **titles = NULL,
	    GtkSelectionMode mode = GTK_SELECTION_SINGLE);
  virtual ~VDKCustom();
  int ColumnClicked() { return SelectedTitle; } 
  GtkSelectionMode SelectionMode();
  GtkWidget*    CustomWidget() { return GTK_WIDGET(custom_widget); }
  void ActiveTitle(int col, bool flag = true);
  void ActiveTitles(bool flag = true);
  void EnableTitles(bool flag = true);
  void Freeze(){ gtk_clist_freeze(GTK_CLIST(custom_widget)); }
  void Thaw() { gtk_clist_thaw(GTK_CLIST(custom_widget)); }
  virtual void Clear() { gtk_clist_clear (GTK_CLIST(custom_widget)); }
  int  Size() { return GTK_CLIST(custom_widget)->rows; }
  void ColumnSize(int col, int size);
  void AutoResizeColumn(int col,bool flag);
  /*  
      override VDKObject property set
  */
  void SetBackground(VDKRgb, GtkStateType);
  void SetForeground(VDKRgb, GtkStateType);
  void SetFont(VDKFont*);
#ifdef USE_SIGCPLUSPLUS
 public:
     VDKSignal1<void, int> OnColumnClick;
 protected:
     static void make_gtksigc_connection(VDKCustom*);
 private:
     static void _handle_click_column(GtkWidget* wid, int col,
				      gpointer obj);

#endif
};
#endif


