/*
file: combowin.cc
*/
#include "combowin.h"
 
/*   
signals map   
*/ 
DEFINE_SIGNAL_MAP(ComboWin,VDKForm)
ON_SIGNAL(combobox,selection_changed_signal,OnComboChange),
ON_SIGNAL(arrows,toggled_signal,OnArrowToggle),
ON_SIGNAL(buttonclear,clicked_signal,OnClearClick),
ON_SIGNAL(buttonadd,clicked_signal,OnAddClick)
END_SIGNAL_MAP 

/*
set up main form
 */
void ComboWin::Setup()
{
   Usize = VDKPoint(250,150);
   VDKBox *frame = new VDKBox(this,v_box);  
   Add(frame,l_justify,TRUE,TRUE,0);
   VDKBox *vbox;
   frame->Add(vbox = new VDKBox(this,v_box));
   vbox->Add(combobox = new VDKCombo(this));
   VDKBox *hbox = new VDKBox(this,h_box);
   label = new VDKLabel(this,"Current selection:",GTK_JUSTIFY_LEFT);
   hbox->Add(label);
   label2 = new VDKLabel(this,"",GTK_JUSTIFY_LEFT);
   hbox->Add(label2);
   vbox->Add(hbox);
   VDKBox *hbox2 = new VDKBox(this,h_box);
   VDKFrame *arrowframe = new VDKFrame(this,"Arrow Keys",v_box,shadow_etched_in);
   arrows = new VDKRadioButtonGroup(this);
   arrows_on = new VDKRadioButton(arrows,"enabled");
   arrows_off = new VDKRadioButton(arrows,"disabled");
   arrowframe->Add(arrows);
   hbox2->Add(arrowframe);
   VDKFrame *buttonframe = new VDKFrame(this,"List",v_box,shadow_etched_in);
   VDKBox *vbox2 = new VDKBox(this,v_box);
   buttonclear = new VDKLabelButton(this,"Clear");
   buttonadd = new VDKLabelButton(this,"Add 5 lines");
   vbox2->Add(buttonclear);
   vbox2->Add(buttonadd);
   buttonframe->Add(vbox2);
   hbox2->Add(buttonframe);
   vbox->Add(hbox2);
   StringList sl;
   VDKString s("This");
   sl.add(s);
   s = "is"; sl.add(s);
   s = "a"; sl.add(s);
   s = "test,"; sl.add(s);
   s = "dude !"; sl.add(s);
   combobox->SetPopdownStrings(sl);
}  

bool ComboWin::OnComboChange(VDKObject *)
{
    int sel = combobox->Selected;
	// modified by Ionutz for gcc 2.95
    VDKString defaultText = "None";
    label2->Caption = (sel == -1) 
	  ? (char*)defaultText
	  : (char*)(combobox->GetPopdownStrings())[sel]; 
    return true;
}

bool ComboWin::OnArrowToggle(VDKObject*)
{
    combobox->UseArrows(arrows->GetSelected() == 0);
    return true;
}

bool ComboWin::OnClearClick(VDKObject*)
{
    combobox->ClearList();
    return true;
}

bool ComboWin::OnAddClick(VDKObject*)
{
    StringList temp = combobox->PopdownStrings;
    char buffer[15];
    for (int i=0; i<5; i++) {
        sprintf(buffer, "Added line %d",i+1);
        VDKString s(buffer);
        temp.add(s);
    }
    combobox->PopdownStrings = temp;
    return true;
}

bool ComboWin::Quit(VDKObject*) 
{ 
   Close(); 
   return true;
}

