/* 
file: ctreewin.cc
*/
#include "ctreewin.h"
const int MAX_TITLES = 1;
// in pixmap.cc
extern char *mini_ofolder_xpm[];
extern char *mini_cfolder_xpm[];
// in src/pixdata.cc
extern char *testo_xpm[];
static  char *titles[] = {"Folders & files"};
static char buff[128];
///////////////////////////////////////////////////
DEFINE_SIGNAL_LIST(TreeWindow,VDKForm);
DEFINE_EVENT_LIST(TreeWindow,VDKForm);
DEFINE_SIGNAL_MAP(TreeWindow,VDKForm) 
  ON_SIGNAL(tree,select_node_signal,ShowSelection),
  ON_SIGNAL(remove,clicked_signal,RemoveSelection),
  ON_SIGNAL(build,clicked_signal,BuildTree),
  ON_SIGNAL(clear,clicked_signal,ClearTree),
  ON_SIGNAL(expand,clicked_signal,ExpandNode)
END_SIGNAL_MAP
   

/*
 */
bool
TreeWindow::ExpandNode(VDKObject* )
{
VDKTreeNode node = tree->SelectedNode;
if(node && ! tree->IsLeaf(node))
  {
    if(tree->IsExpanded(node))
      gtk_ctree_collapse_recursive(GTK_CTREE(tree->CustomWidget()),node);
    else
      gtk_ctree_expand_recursive(GTK_CTREE(tree->CustomWidget()),node);
  }
return true;
}
/* 
 */  
bool 
TreeWindow::RemoveSelection(VDKObject* )
{
  VDKTreeNode node = NULL;
  VDKTreeNodeArray& selections = tree->Selections();
  if( (selections.size() == 0) && (node = tree->SelectedNode) )
	tree->RemoveNode(node);
  else
    {
      tree->Freeze();
      for(int j = 0; j < selections.size(); j++)
	tree->RemoveNode(selections[j]);
      tree->Thaw();
    }
  if(tree->Size() == 0)
    {
      remove->Enabled = false;
      build->Enabled = true;
    }
  return true;
}
 
/* 
 */  
bool 
TreeWindow::ClearTree(VDKObject* obj)
{
  tree->Clear();
  remove->Enabled = false;
  build->Enabled = true;
  return true;
}
/*
 */
bool TreeWindow::Quit(VDKObject*) { Close(); return true; }

/*
 */
bool 
TreeWindow::ShowSelection(VDKObject* obj)
{ 
  VDKCustomTree* aTree = NULL;
  VDKTreeNode node;
  Tuple tuple;
  int t,j;
  // downcast from VDKObj to VDKCustomTree
  aTree = dynamic_cast<VDKCustomTree*>(obj);
  // when called by button surely fails
  aTree = aTree ? aTree : tree;
  
  VDKTreeNodeArray& selections = aTree->Selections();
  if(selections.size() == 0)
    {
      node = aTree->SelectedNode;
      if(node && aTree->IsLeaf(node))
	{
	  tuple = (*aTree)[node];
	  for(t = 0; t < tuple.size(); t++)
	    printf("\ncol:%d, text:%s",t,(char*) tuple[t]);
	  fflush(stdout);
	}
    }
  else
    {
      for(j = 0; j < selections.size(); j++)
	{ 
	  tuple = (*aTree)[selections[j]];
	  for(t = 0; t < tuple.size(); t++)
	    printf("\ncol:%d, text:%s",t,(char*) tuple[t]);
	  fflush(stdout);
	}
    }
  return true;
}
/*
 */ 
bool 
TreeWindow::ShowExtendedSelection(VDKObject* obj, GdkEvent*)
{
  // downcast from VDKObj to VDKCustomTree
  VDKCustomTree* aTree = dynamic_cast<VDKCustomTree*>(obj);
  g_return_val_if_fail(aTree != NULL,false);
  VDKTreeNodeArray& selections = aTree->Selections();
  if(selections.size() > 1)
    ShowSelection(obj);
  printf("\nselection size:%d",selections.size());
  fflush(stdout);
  return true;
}
/* 
 */
#define RAND_RANGE  20.0
bool 
TreeWindow::BuildTree(VDKObject*)
{
  VDKTreeNode node; 
  int t = 0,siblings = 3;
  int depth = 2; 
  char* text = &buff[0];
  tree->Freeze();
  // add a root + 3 siblings 
  sprintf(buff,"Folder 1");
  node = tree->AddNode(&text,NULL,
		       true,false, mini_cfolder_xpm, mini_ofolder_xpm);
  for(t = 0; t < siblings; t++)
    {
      sprintf(buff,"File %d",t);
      tree->AddNode(&text,node,false,true,testo_xpm);
    }
  // add a root + depth childs + a sibling
  sprintf(buff,"Folder 2");
  node = tree->AddNode(&text,NULL,
		       true,false, mini_cfolder_xpm, mini_ofolder_xpm); 
  for(t = 0;  t < depth;  t++) 
    {
      sprintf(buff,"Folder %d",t+3);
      node = tree->AddNode(&text,node, 
			   true,false, mini_cfolder_xpm, mini_ofolder_xpm);
    }
  sprintf(buff,"File 1");
  tree->AddNode(&text,node,false,true,testo_xpm);
  // add again a root + 10 siblings
  siblings = 10;
  sprintf(buff,"Folder 5");
  node = tree->AddNode(&text,NULL,
		       true,false, mini_cfolder_xpm, mini_ofolder_xpm);
  for(t = 0; t < siblings; t++)
    {
      sprintf(buff,"File %d",t);
      tree->AddNode(&text,node,false,true,testo_xpm);
    }
  tree->Thaw();
  build->Enabled = false;
  remove->Enabled = true;
  // select first node
  tree->SelectedNode = NULL;
  return true;
}
///////////////////////////////////////////////////

void    
TreeWindow::Setup() 
{
  tree = new VDKCustomTree(this,MAX_TITLES,titles,GTK_SELECTION_EXTENDED);
  // set tree properties
  tree->LineStyle = GTK_CTREE_LINES_DOTTED;
  tree->ActiveTitle(0,false);
  tree->SetSize(300,300); 
  Add(tree);
  // 
  VDKFrame * frame = new VDKFrame(this,NULL,h_box);
  quit = new VDKLabelButton(this,"Quit");
  remove = new VDKLabelButton(this,"Remove selected nodes");
  build = new VDKLabelButton(this,"Rebuild tree");
  clear = new VDKLabelButton(this,"Clear tree");
  expand = new VDKCustomButton(this,"Expand/Collapse");
  frame->Add(quit,l_justify);
  frame->Add(remove,l_justify);
  frame->Add(clear,l_justify);
  frame->Add(build,l_justify);
  frame->Add(expand,l_justify);
  Add(frame,l_justify,false,false,false);
  // load tree
  BuildTree(NULL);
  // dyna tables
  SignalConnect(quit,"clicked",&TreeWindow::Quit);
  // when mouse is released shows multiple selections (if any)
  EventConnect(tree,"button_release_event",&TreeWindow::ShowExtendedSelection);
  printf("\ntree size:%d",tree->Size());
  fflush(stdout);
 }







